/*
 * gpmtool.cpp
 *
 * Copyright (c) 2002 by DSP Technology Co.,Ltd. All Rights Reserved.
 * $Revision: 1.4 $
 *
 */
#ifdef WIN32
#include <Windows.h>
#endif
#include <process.h>
#include <stdlib.h>
#include <tchar.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "gpmtool.h"

#ifndef True
#define True  1
#define False 0
#endif

//GpmToolpO[o
#define		MAX_GPMTOOL		10
GpmToolDlg	*p_gpmtool[MAX_GPMTOOL];

#ifdef __cplusplus
extern "C" {
#endif

TCHAR script_msg[] = TEXT("inline(\"ispp1.sl\")");

void GpmtoolApply()
{
	HWND hwnd;
	hwnd = FindWindow(NULL, "SATELLITE Language");
	char ch;
	for(int i=0;i<strlen(script_msg);i++){
		ch = script_msg[i];
		::PostMessage(hwnd,WM_CHAR,TCHAR(ch),0L);
	}
	::PostMessage(hwnd,WM_CHAR,TCHAR('\n'),0L);
}

/*+++      Helper routine.
	Take an input pointer, return closest
	pointer that is aligned on a DWORD (4 byte) boundary.
---*/
LPWORD lpwAlign ( LPWORD lpIn)
{   
	ULONG ul;
    ul = (ULONG) lpIn;
	ul +=3;
	ul >>=2;
	ul <<=2;
	return (LPWORD) ul;
}
/*+++
  Helper routine.
  Takes second parameter as Ansi string, copies
      it to first parameter as wide character (16-bits / char) string,
      and returns integer number of wide characters (words) in string
      (including the trailing wide char NULL).
---*/
int nCopyAnsiToWideChar (LPWORD lpWCStr, LPSTR lpAnsiIn)
{   
	int cchAnsi = lstrlen(lpAnsiIn);
    return MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, lpAnsiIn, cchAnsi, lpWCStr, cchAnsi) + 1;
}
 
long FAR PASCAL DlgProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int	dlg,id;
	HWND hchild,hview;

	switch (message)
	{
	case	WM_DESTROY:
		::PostQuitMessage(0);
		return TRUE;
	case WM_INITDIALOG:
		//Ot
		hchild = ::GetDlgItem(hwnd, 100);
		if(hchild) {
			::SendMessage(hchild,LB_ADDSTRING,0,(LPARAM)"Vertical Bar");
			::SendMessage(hchild,LB_ADDSTRING,0,(LPARAM)"Horizontal Bar");
			//::SendMessage(hchild,LB_SETCURSEL,0,0L);
		}
		return TRUE; // indicate we did not set focus to the control
	case WM_COMMAND:
		switch (wParam)
		{
		case IDOK:
			//nj{^;
			//DestroyWindow(hwnd);
			GpmtoolApply();
			return TRUE;
		case IDCANCEL:
			//{^
			//::DestroyWindow(hwnd);
			::PostQuitMessage(0);
			//for(dlg = 0; dlg < MAX_GPMTOOL; dlg++) {
			//	if(hwnd == p_gpmtool[dlg]->m_hwnd) {
			//	TerminateThread(p_gpmtool[dlg]->m_hThread, dlg);
			//		break;
			//	}
			//}
			return TRUE;
		}
		id = (int)LOWORD(wParam);
		if(id == 100) {
			//Xg{bNXHWND
			hchild = (HWND)lParam;
			//FrameHWND
			hview = ::GetDlgItem(hwnd, 101);

			//
			for(dlg = 0; dlg < MAX_GPMTOOL; dlg++) {
				if(!p_gpmtool[dlg])
					continue;
				if(hwnd == p_gpmtool[dlg]->m_hwnd) {
					p_gpmtool[dlg]->PreView(hview);
				}
			}
			return TRUE;
		}
		return FALSE;
	default: return FALSE;
	}
}


void __cdecl GpmtoolThread(LPVOID count)
{
	//_CAO
	if(!p_gpmtool[(int)count]->CreateDialogGpmtool())
		return;

	//bZ[W[v
	MSG msg;
    while(GetMessage(&msg, NULL, NULL, NULL)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
	//::DestroyWindow(p_gpmtool[(int)count]->m_hwnd);
	//::ExitThread(0);
	//return TRUE;
}

//
// gpmtoolR}h
DLLEXPORT int GpmTool()
{
	int index[MAX_INDEX];
	int dim;
	Buffer  *x;
	char *title;

	//IuWFNg
	if (( x = GetSeries( 0, &dim, index ) ) == NULL )
          return (4);	//Buffer read error
	title = GetString(0);

	//GpmToolDlgNX𐶐
	for(int dlg = 0; dlg < MAX_GPMTOOL; dlg++) {
		if(p_gpmtool[dlg] == NULL) {
			p_gpmtool[dlg] = new GpmToolDlg();
			if(!p_gpmtool[dlg]->Init(dlg, title, dim, index, x))
                          return (46);
			break;
		}
	}
	return 0;
}

//
// OR}hŏ΁AvJ[\ɕύXȂB
// gpmtoolR}h
DLLEXPORT int GpmToolCls()
{
	::TerminateThread(p_gpmtool[0]->m_hThread, 0);
	return 0;
}

#ifdef __cplusplus
}
#endif

/////////////////////////////////////////////////////////////////////////////
// GpmToolDlgNX

GpmToolDlg::GpmToolDlg()
{
}

GpmToolDlg::~GpmToolDlg()
{
}

BOOL GpmToolDlg::Init(int dlg, char *title, int dim, int index[], Buffer *x)
{
	int	i;
	DWORD threadID;

	//f[^ݒ
	sprintf(m_title,"Object->%s",title);
	m_dim = dim;
	for(i=0;i<MAX_INDEX;i++)
		m_index[i] = index[i];
	for(i = 0; i < m_index[0]; i++)
		m_buffer[i] = x[i];

	//Xbhœ
	m_hThread = CreateThread( 0, 0,
		(LPTHREAD_START_ROUTINE)GpmtoolThread, (LPVOID)dlg, 0, &threadID);
	if(!m_hThread)
		return FALSE;
#if 0
	rtval = GetThreadPriority( m_hThread );
	if(rtval == THREAD_PRIORITY_ERROR_RETURN) {
		MessageBox(NULL,"GetThreadPriority error.","SL_Shell",MB_OK);
		return FALSE;
	}
	if(!SetThreadPriority(m_hThread, THREAD_PRIORITY_ABOVE_NORMAL)) {
		MessageBox(NULL,"SetThreadPriority error.","SL_Shell",MB_OK);
		return FALSE;
	}
#endif

	return TRUE;
}

//
// StaticRg[쐬
//
WORD* GpmToolDlg::CreateCtrlText(WORD *p,int x,int y,int cx,int cy,WORD id, char *text)
{
  int   nchar;
  DWORD lStyle;

  /* make sure the first item starts on a DWORD boundary */
  p = lpwAlign (p);
  /* now start with the first item */
  lStyle = SS_LEFT | WS_VISIBLE | WS_CHILD;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
  *p++ = x;         // x
  *p++ = y;         // y
  *p++ = cx;         // cx
  *p++ = cy;         // cy
  *p++ = id;       // ID
  /* fill in class i.d. Button in this case */
  *p++ = (WORD)0xffff;
  *p++ = (WORD)0x0082;
  /* copy the text of the first item */
  nchar = nCopyAnsiToWideChar (p, text);
  p += nchar;
  *p++ = 0;
  return p;
}

//
// EditRg[쐬
//
WORD* GpmToolDlg::CreateCtrlEdit(WORD *p,int x,int y,int cx,int cy,WORD id, char *text)
{
  int   nchar;
  DWORD lStyle;

  /* make sure the first item starts on a DWORD boundary */
  p = lpwAlign (p);
  /* now start with the first item */
  lStyle = ES_LEFT | WS_VISIBLE | WS_CHILD | WS_BORDER;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
  *p++ = x;         // x
  *p++ = y;         // y
  *p++ = cx;         // cx
  *p++ = cy;         // cy
  *p++ = id;       // ID
  /* fill in class i.d. Button in this case */
  *p++ = (WORD)0xffff;
  *p++ = (WORD)0x0081;
  /* copy the text of the first item */
  nchar = nCopyAnsiToWideChar (p, text);
  p += nchar;
  *p++ = 0;
  return p;
}

//
// ButtonRg[쐬
//
WORD* GpmToolDlg::CreateCtrlButton(WORD *p,int x,int y,int cx,int cy,WORD id, char *text)
{
  int   nchar;
  DWORD lStyle;

  /* make sure the first item starts on a DWORD boundary */
  p = lpwAlign (p);
  /* now start with the first item */
  lStyle = BS_PUSHBUTTON | WS_VISIBLE | WS_CHILD;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
  *p++ = x;         // x
  *p++ = y;         // y
  *p++ = cx;         // cx
  *p++ = cy;         // cy
  *p++ = id;       // ID
  /* fill in class i.d. Button in this case */
  *p++ = (WORD)0xffff;
  *p++ = (WORD)0x0080;
  /* copy the text of the first item */
  nchar = nCopyAnsiToWideChar (p, text);
  p += nchar;
  *p++ = 0;
  return p;
}

//
// ListboxRg[쐬
//
WORD* GpmToolDlg::CreateCtrlListbox(WORD *p,int x,int y,int cx,int cy,WORD id, char *text)
{
  int   nchar;
  DWORD lStyle;

  /* make sure the first item starts on a DWORD boundary */
  p = lpwAlign (p);
  /* now start with the first item */
  lStyle = LBS_STANDARD | WS_VISIBLE | WS_CHILD;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
  *p++ = x;         // x
  *p++ = y;         // y
  *p++ = cx;         // cx
  *p++ = cy;         // cy
  *p++ = id;       // ID
  /* fill in class i.d. Button in this case */
  *p++ = (WORD)0xffff;
  *p++ = (WORD)0x0083;
  /* copy the text of the first item */
  nchar = nCopyAnsiToWideChar (p, text);
  p += nchar;
  *p++ = 0;
  return p;
}

//
// FrameRg[쐬
//
WORD* GpmToolDlg::CreateCtrlFrame(WORD *p,int x,int y,int cx,int cy,WORD id, char *text)
{
  int   nchar;
  DWORD lStyle;

  /* make sure the first item starts on a DWORD boundary */
  p = lpwAlign (p);
  /* now start with the first item */
  lStyle = SS_WHITEFRAME | WS_VISIBLE | WS_CHILD | WS_BORDER;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
  *p++ = x;         // x
  *p++ = y;         // y
  *p++ = cx;         // cx
  *p++ = cy;         // cy
  *p++ = id;       // ID
  /* fill in class i.d. Button in this case */
  *p++ = (WORD)0xffff;
  *p++ = (WORD)0x0082;
  /* copy the text of the first item */
  nchar = nCopyAnsiToWideChar (p, text);
  p += nchar;
  *p++ = 0;
  return p;
}

BOOL GpmToolDlg::CreateDialogGpmtool()
{
  WORD  *p, *pdlgtemplate;
  int   nchar;
  DWORD lStyle;

  /* allocate some memory to play with  */
  pdlgtemplate = p = (PWORD) LocalAlloc (LPTR, 1000);
  /* start to fill in the dlgtemplate information.addressing by WORDs */
  lStyle = DS_MODALFRAME | DS_SETFONT | WS_CAPTION | WS_SYSMENU | WS_VISIBLE;
  *p++ = LOWORD (lStyle);
  *p++ = HIWORD (lStyle);
  *p++ = 0;          // LOWORD (lExtendedStyle)
  *p++ = 0;          // HIWORD (lExtendedStyle)
//dv
  *p++ = 6;          // NumberOfItems
  *p++ = 10;         // x
  *p++ = 10;         // y
  *p++ = 210;        // cx
  *p++ = 100;        // cy
  *p++ = 0;          // Menu
  *p++ = 0;          // Class
  /* copy the title of the dialog */
  if (PRIMARYLANGID(GetUserDefaultLangID ()) == LANG_JAPANESE)
	nchar = nCopyAnsiToWideChar(p, m_title);
	//nchar = nCopyAnsiToWideChar (p, TEXT(" ^ C g   1"));
  else
	  nchar = nCopyAnsiToWideChar (p, TEXT("Title 1"));
  p += nchar;	//
  /* add in the wPointSize and szFontName here iff the DS_SETFONT bit on */
/*DS_SETFONTw肵̂*/
  *p++ = 10;
  //*p++ = 100;
  //*p++ = TRUE;
  nchar = nCopyAnsiToWideChar (p, TEXT("Arial"));
  p += nchar;

  ////////////////////////////////////////////////////////
  //	"Object"
  p = CreateCtrlText(p,10,10,40,12,0xffff,"Object:");

  ////////////////////////////////////////////////////////
  //	Object
  p = CreateCtrlEdit(p,60,8,40,14,0xffff,"x");

  ////////////////////////////////////////////////////////
  //	Apply{^
  p = CreateCtrlButton(p,10,70,40,16,IDOK,"Apply");

  ////////////////////////////////////////////////////////
  //	Apply{^
  p = CreateCtrlButton(p,60,70,40,16,IDCANCEL,"Cancel");

  //	Xg{bNX
  p = CreateCtrlListbox(p,10,25,60,45,100,"Type");
  //	Frame
  p = CreateCtrlFrame(p,110,25,50,50,101,"Frame");

  // advance pointer over nExtraStuff WORD
  HWND hparent;
  hparent = ::FindWindow(NULL, "SATELLITE Language");
  m_hwnd = ::CreateDialogIndirect ((HINSTANCE)GetModuleHandle(NULL)/*hinst*/, 
	  (LPDLGTEMPLATE) pdlgtemplate, hparent, (DLGPROC)DlgProc);
  if(!m_hwnd) {
	  //ŃbZ[WoĂ\Ȃ
	  //printf("Can't create gpmtool.\n");
	  return FALSE;
  }
  ::ShowWindow(m_hwnd, SW_SHOW);
  ::LocalFree (LocalHandle (pdlgtemplate));
  return TRUE;

}

BOOL GpmToolDlg::PreView(HWND hwnd)
{
	RECT	rect;
	HBRUSH	hBrush;
	HPEN	hPen;
	HGDIOBJ	hOldBrush,hOldPen;
	double max,min;
	int		i,xs,ys,xe,ye,width,height;
	HRGN	hRgn;
	HRGN	hOldRgn;
	HDC		hdc;

	hdc = ::GetDC(hwnd);
	::SetMapMode(hdc, MM_TEXT);
	::SetBkMode(hdc, TRANSPARENT);
	::SetTextColor(hdc, (DWORD) 0x00000000);
	hPen = ::CreatePen(PS_SOLID, 0, (DWORD) 0x000000FF);
	hOldPen = ::SelectObject(hdc, hPen);
	hBrush = ::CreateSolidBrush( (DWORD) 0x0000FF00);
	hOldBrush = ::SelectObject(hdc, hBrush);
	::GetClientRect(hwnd, &rect);

	hRgn = ::CreateRectRgn(rect.left, rect.top,
			rect.right, rect.bottom);
	hOldRgn = (HRGN)::SelectClipRgn( hdc, hRgn);
	::FillRect(hdc, &rect, hBrush);

	//Ot
	width = rect.right - rect.left;
	height = rect.bottom - rect.top;
	max=-1e6; min=1e6;
	for(i=0;i<m_index[0];i++) {
		if(m_buffer[i]>max)
			max = m_buffer[i];
		if(m_buffer[i]<min)
			min = m_buffer[i];
	}
	for(i=0;i<m_index[0];i++) {
		if(i==0) {
			xe = (int)((double)i * width / m_index[0]);
			ye = height - (int)((m_buffer[i]-min)*height/(max-min));
			//ye = height - (int)(bmptr[i]);
		}
		else {
			xe = (int)((double)i * width / m_index[0]);
			ye = height - (int)((m_buffer[i]-min)*height/(max-min));
			//ye = height - (int)(bmptr[i]);
			::MoveToEx(hdc,xs,ys,NULL);
			::LineTo(hdc,xe,ye);
		}
		xs = xe; ys = ye;
	}
	SelectClipRgn( hdc, hOldRgn);
	DeleteObject( hRgn );

	SelectObject(hdc, hOldBrush);
	DeleteObject(hBrush);
	SelectObject(hdc, hOldPen);
	DeleteObject(hPen);
	::ReleaseDC(hwnd, hdc);

	return TRUE;
}
