/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: image.cpp,v 1.2 2004/05/18 07:34:48 orrisroot Exp $ */

#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"

#include "xbm2data.h"

/* line command parameter */
extern struct image_param ImageParam;

int GpmWindow::GPM_image()
{
  int stat;
  int idx = 0, idy = 0;
  int x_hot, y_hot;
  gint xpos,ypos,wh,ww,depth;
  int errcode;
  char *imagedata;
  unsigned int width;
  unsigned int height;

  GdkBitmap *bitmap;

  /* currently image command was suppted on window only */
  if(GpmCont.device == 2){ return 0; }

  /* xbm data only */
  errcode = sl4_xbm2data(ImageParam.image, &imagedata, &width, &height, 
                         &x_hot, &y_hot);
  switch(errcode){
  case XBM2DATA_SUCCESS:  /* nothing */  break;
  case XBM2DATA_OPEN_FAILED:  return 38; /* image file not found      */ break;
  case XBM2DATA_INVALID_FILE: return 39; /* invalid image data format */ break;
  case XBM2DATA_BAD_ALLOC:    return 40; /* image file is too large   */ break;
  }

  gopen(GpmCont.paper, GpmCont.orientation, GpmCont.device, GpmCont.winNum);
  gnewpen(GpmCont.fColor);
  gpen(GpmCont.fLineWidth, GpmCont.fLineType, 0);
  gfsize(GpmCont.xSize, GpmCont.ySize);
  gfactor(GpmCont.factor);
  gorigin(GpmCont.xOrigin, GpmCont.yOrigin);

  if(ImageParam.number != 0){
    gdk_window_get_geometry(m_window->window, &xpos, &ypos, &ww, &wh, &depth);
    if(ImageParam.number == 1){
      idx = ImageParam.dx + mgraph.xorg * mdev.ffx;
      idy = wh - ImageParam.dy - height - mgraph.yorg * mdev.ffy;
    }else{
      idx = ImageParam.dx;
      idy = wh - ImageParam.dy - height;
    }
  }else{
    idx = (ImageParam.dx + mgraph.xorg ) * mdev.ffx;
    idy = mdev.iyleng-((ImageParam.dy + mgraph.yorg) * mdev.ffy) - height;
  }

  bitmap = gdk_bitmap_create_from_data(m_window->window, imagedata,
                                       width, height);
  gdk_gc_set_clip_origin(gpm_gc, idx, idy);
  gdk_gc_set_clip_mask(gpm_gc, bitmap);
  gdk_draw_rectangle(m_window->window, gpm_gc, TRUE, idx, idy, width, height);
  gdk_draw_rectangle(m_pixmap, gpm_gc, TRUE, idx, idy, width, height);
  gdk_gc_set_clip_mask(gpm_gc, NULL);
  gdk_bitmap_unref(bitmap);
  free(imagedata);

  gflush();
  stat = gclose();
  return stat;
}
