/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: image_new.cpp,v 1.2 2004/05/18 07:34:48 orrisroot Exp $ */

/*
 * image_new.cpp
 *
 * Copyright (c) 2002 by DSP Technology Co.,Ltd. All Rights Reserved.
 * $Revision: 1.1.1.1 $
 *
 */

#if 0

#include <windows.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/win32/gdkwin32.h>
#include <io.h>
#include <vfw.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"

/* line command parameter */
extern struct image_param ImageParam;
static	void *m_Bitmap;
static HDRAWDIB m_drawDIBBlock;
static void Win32BitmapCreate(HDC hDCMem, int xp, int yp, int cx, int cy, char* bmpfile);
static void InitviewOpen();
static void InitviewClose();
static BOOL InitviewRead(char* file);
static void InitviewDraw(HDC hDCMem, RECT rect);
static BYTE *GetBitmapBits();
static void *LoadBitmapFile(int fd);
static HGLOBAL GetBitmap();
static unsigned char *ReadBitmapFile(char *file, unsigned int *width,
                                     unsigned int *height, int *x_hot, 
                                     int *y_hot);

int GpmWindow::GPM_image()
{
  int            numer;
  char          *ialpha;
  int            status;
  unsigned int   width, height;
  GdkPixmap      *pPixmap;
  GdkBitmap		 *mask;
  GdkBitmap*	pBitmap;
  GtkStyle *style;
  int            x_hot, y_hot;
  double          dx, dy;
  int            idx = 0, idy = 0;
  int            xpos, ypos, win_width, win_height, depth, wx, wy;
  unsigned char	 *pData;
  int            stat;
  HDC hdc;
  //XWindowAttributes atr;

  //regpm();

  ialpha  = ImageParam.ialpha;
  dx      = ImageParam.dx;
  dy      = ImageParam.dy;
  numer   = ImageParam.numer;
  
  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.gColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType,0);
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  if(strstr(ialpha,".xbm") != NULL) {
		pData = ReadBitmapFile (ialpha, &width, &height, &x_hot, &y_hot);
		if(pData == NULL)
			return (38);
		//style=gtk_widget_get_style(m_window);
		pBitmap = gdk_bitmap_create_from_data(m_window->window,
			(const char *)pData,width, height);
		if(pBitmap == NULL)
			return (38);
	  if (numer != 0) {

		//XGetWindowAttributes(gpm_display, gpm_window, &atr);
		gdk_window_get_geometry(m_window->window, &xpos, &ypos, &win_width, &win_height, &depth);
		wx = win_width;
		wy = win_height;
		if ( numer == 1) {
		  idx = dx + mgraph.xorg * mdev.ffx ;
		  idy = wy - dy - height - mgraph.yorg * mdev.ffy ;
		}
		else if ( numer == 2) {
		  idx = dx ;
		  idy = wy - dy - height ;
		}
	  }
	  else {
		idx=( dx + mgraph.xorg ) * mdev.ffx;
		idy=mdev.iyleng-((dy + mgraph.yorg) * mdev.ffy)-height;
	  }
		gdk_gc_set_stipple(gpm_gc, pBitmap);
		gdk_gc_set_ts_origin(gpm_gc, idx % width, idy % height);
		gdk_gc_set_fill(gpm_gc, GDK_STIPPLED);

		//gdk_draw_rectangle(m_pixmap, gpm_gc, TRUE,
		//		idx, idy, width, height);
		//pPixmapƕ\\
		//pPixmap = gdk_pixmap_create_from_xpm(m_window->window, &mask, NULL,
		//	"icon.xpm");
		//gdk_draw_pixmap(m_pixmap, gpm_gc, pPixmap, 0, 0,
		//	idx, idy, 32, 32);
		gdk_draw_pixmap(m_pixmap, gpm_gc, pBitmap, 0, 0,
			idx, idy, width, height);
  }
  else {
	width = dx * mwin.ffx;
	height = dy * mwin.ffy;
	idx=mgraph.xorg*mwin.ffx;
	idy=mdev.iyleng-(mgraph.yorg*mwin.ffy)-height;
	hdc = gdk_win32_hdc_get (m_pixmap, gpm_gc, GDK_GC_FOREGROUND);
	Win32BitmapCreate((HDC)hdc, idx, idy,
		width, height, ialpha);
	gdk_win32_hdc_release (m_pixmap, gpm_gc, GDK_GC_FOREGROUND);
  }

  gflush();
  stat = gclose() ;

  free(pData);
  //wrgpm() ;
  return stat;
}

static unsigned char *ReadBitmapFile(char *file, unsigned int *width,
                                     unsigned int *height, int *x_hot, 
                                     int *y_hot)
{
  FILE *fp;
  char tmpdef[_MAX_PATH];
  char tmpstr[_MAX_PATH];
  unsigned char *data;
  char cp;
  int	num,i,cnt,tmp_width,tmp_height,pixel;
  
  if((fp = fopen(file, "r")) == NULL)
    return NULL;
  fscanf(fp,"%s %s %d",tmpdef, tmpstr, &tmp_width);
  fscanf(fp,"%s %s %d",tmpdef, tmpstr, &tmp_height);
  fscanf(fp,"%s %s %d",tmpdef, tmpstr, x_hot);
  fscanf(fp,"%s %s %d",tmpdef, tmpstr, y_hot);
  
  //f[^
  if((tmp_width % 8) == 0)
    num = tmp_width / 8 * tmp_height;
  else
    num = (tmp_width / 8 + 1) * tmp_height;
  data = (unsigned char *)malloc(num+1);
  // '{'
  for(;;) {
    cp = fgetc(fp);
    if(cp == '{')	break;
  }
  // '}'܂
  cnt = 0; i=0;
  for(;;) {
    cp = fgetc(fp);
    if(cp!='\n' && cp!= ' ') {
      if(cp == ',' || cp == '}') {	//1f[^I
        tmpstr[i] = '\0';
        //
        sscanf(tmpstr,"%x",&pixel);
        //data[cnt] = (unsigned char)atoi(tmpstr);
        data[cnt] = pixel;
        cnt++;
        i=0;
        if(cp == '}')
          break;
      }
      else
        tmpstr[i++] = cp;
    }
  }
  *width = tmp_width;
  *height = tmp_height;
  return data;
}

static void Win32BitmapCreate(HDC hDCMem, int xp, int yp, int cx, int cy, 
                              char* bmpfile)
{
	InitviewOpen();
	InitviewRead(bmpfile);
	RECT rect;
	rect.left = xp;
	rect.top = yp;
	rect.right = xp+cx;
	rect.bottom = yp+cy;
	InitviewDraw( hDCMem, rect );
	InitviewClose();
}

static void InitviewOpen()
{
	// DrawDib APĨI[v
	m_Bitmap = NULL;
	m_drawDIBBlock = DrawDibOpen();
}

static void InitviewClose()
{
	// DrawDib APĨN[Y
	if (m_drawDIBBlock)
		DrawDibClose(m_drawDIBBlock);
	if (m_Bitmap) {
		delete m_Bitmap;
		m_Bitmap = NULL;
	}
}

static BOOL InitviewRead(char* file) 
{

	// t@C̃I[v
	char filename[128];
	char msgbuf[_MAX_PATH];
	int fd;

	strcpy(filename, file);
	fd = _open(filename, 0/*O_RDONLY*/);
	if(fd < 0)
		return 0;

	// t@C̓ǂݍ
	if (m_Bitmap) {
		delete m_Bitmap;
		m_Bitmap = NULL;
	}
	m_Bitmap = LoadBitmapFile(fd);

	_close(fd);

	return TRUE;
}

static void InitviewDraw(HDC hDCMem, RECT rect)
{

	// rbg}bv̎擾
	BITMAPINFOHEADER* bitmap = (BITMAPINFOHEADER*)GetBitmap();

	if (bitmap) {
		// ײ
		int	c_width,c_height;
		c_width = rect.right - rect.left;
		c_height = rect.bottom - rect.top;
		// rbg}bv̍ƕ
		int width, height;
		width = bitmap->biWidth,
		height = bitmap->biHeight;

		// ݂̂cb̃pbgI
		DrawDibRealize( m_drawDIBBlock, hDCMem, TRUE);

		// rbg}bv̕`
		DrawDibDraw(m_drawDIBBlock, hDCMem,
					rect.left, rect.top, c_width, c_height,	// `
					bitmap, (LPVOID) GetBitmapBits(),	// rbg}bv
					0, 0, width, height,					// `挳
					DDF_BACKGROUNDPAL);
	}
}

static BYTE*GetBitmapBits()
{
	DWORD numOfColors;
	BITMAPINFOHEADER *pBitmap = (BITMAPINFOHEADER*)GetBitmap();
	WORD bitCount = pBitmap->biBitCount;

	if (pBitmap->biSize >= 36)
		numOfColors = pBitmap->biClrUsed;
	else
		numOfColors = 0;

	if (numOfColors == 0 && bitCount != 24) 
			numOfColors = 1L << bitCount;

	return (BYTE*)pBitmap + pBitmap->biSize + numOfColors * sizeof(RGBQUAD);
}


#define BMP_HEADER_ID       (*((WORD*)"BM"))
#define BMP_HEADER_SIZE		sizeof(BITMAPFILEHEADER)

static void* LoadBitmapFile(int fd)
{
	BITMAPFILEHEADER bmpHeader;
	unsigned long fileSize, leftSize;
	void *bitmap;

	// t@C̒
	fileSize = _lseek(fd, 0L, SEEK_END);

	// rbg}bvwb_[̎擾
	_lseek(fd, 0L, SEEK_SET);
	if (_read(fd, (LPSTR)&bmpHeader, BMP_HEADER_SIZE) != BMP_HEADER_SIZE)
		return NULL;

	// rbg}bvt@Cł邱Ƃ̊mFibfType=="BM" ?j
	if (bmpHeader.bfType != BMP_HEADER_ID) {
		MessageBox(NULL,"BITMAPł͂܂","image",MB_OK);
		return NULL;
	}

	// [hp̊m
	bitmap = (void*)new char[fileSize];

	// rbg}bv̓ǂݍ
	leftSize = fileSize - BMP_HEADER_SIZE;
	if (_read(fd, bitmap, leftSize) != leftSize) {
		delete bitmap;
		return NULL;
	}

	return bitmap;
}

static HGLOBAL GetBitmap()
{
	return m_Bitmap;

}

#endif /* 0 */
