/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: noise.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

/*************************
    noise.c
    coded by Takashi KODERA
    March 9th, 1992
**************************/

#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"

/* noise command parameter */
extern struct noise_param NoiseParam;

int GpmWindow::GPM_noise()
{

  double norm=32767.0;
  double value;
  int colorflag;
  int x,y;
  int size;
  int xnum, ynum, loop, num, wnum;
  int stat;

  //regpm() ;

  xnum = NoiseParam.xnum;
  ynum = NoiseParam.ynum;
  size = NoiseParam.size;
  loop = NoiseParam.loop;
  wnum = NoiseParam.wnum;

  xnum = ( xnum > 0 ) ? xnum : 13;
  ynum = ( ynum > 0 ) ? ynum : 13;
  size = ( size > 0 ) ? size : 10;
  loop = ( loop > 0 ) ? loop : 100;
  wnum = ( wnum > 0 ) ? wnum : 100;
  
  GpmCont.device = 0;
  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.fColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0) ;
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  colorflag=0;

  GdkColor white      = GdkWhitePixel ();
  GdkColor black      = GdkBlackPixel ();
  gdk_threads_enter();
  gdk_gc_set_foreground(gpm_gc, &white);
  gdk_threads_leave();

  num=0;
  while (num<loop) {

    for (x=0; x<xnum; x++) {
      for (y=0; y<ynum; y++) {

#ifdef WIN32
	value=1.0*(double)rand()/norm;
#else
	value = (double)rand() / RAND_MAX;
#endif

	if ((value<0.5)&&(colorflag==1)) {
      gdk_threads_enter();
	  gdk_gc_set_foreground(gpm_gc, &white);
      gdk_threads_leave();
	  colorflag=0;
	}
	else if ((value<0.5)&&(colorflag==0)) {
      gdk_threads_enter();
	  gdk_gc_set_foreground(gpm_gc, &black);
      gdk_threads_leave();
	  colorflag=1;
	}

	gbox((double)(x*size),(double)(y*size),
	     (double)(x*size+size),(double)(y*size)+size, 3, -1.0);
      } 
    }
    num++;
    gflush();
    wait_msec2(wnum);
  }

  stat = gclose();
  return stat;
}
