/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: xbm2data.h,v 1.1 2004/05/18 06:31:47 orrisroot Exp $ */

#ifndef _SL4_XBM2DATA_H_
#define _SL4_XBM2DATA_H_

#ifdef __cplusplus
extern "C" {
#endif

#define XBM2DATA_SUCCESS       0  /* success                 */
#define XBM2DATA_OPEN_FAILED  -1  /* xbm file open failed    */
#define XBM2DATA_INVALID_FILE -2  /* invalid xbm file format */
#define XBM2DATA_BAD_ALLOC    -3  /* out of memory           */

/* Read XBM formated image file to memory */
/*   retval :  0 XBM2DATA_SUCCESS      - success                 */
/*            -1 XBM2DATA_OPEN_FAILED  - xbm file open failed    */
/*            -2 XBM2DATA_INVALID_FILE - invalid xbm file format */
/*            -3 XBM2DATA_OUT_MEMORY   - out of memory           */
int sl4_xbm2data(const char *filename, char **xbmdata, unsigned int *width,
                 unsigned int *height, int *x_hot, int *y_hot);

#ifdef __cplusplus
}
#endif

#endif /* _SL4_XBM2DATA_H_ */
