/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: xlabel.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include <gtk/gtk.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
#include "GpmWindow.h"
#include "GpmThread.h"
  
#ifndef ALIGN_LEFT
#define ALIGN_LEFT   0
#define ALIGN_CENTER 1
#define ALIGN_RIGHT  2
#define ALIGN_TOP    0
#define ALIGN_MIDDLE 1
#define ALIGN_BOTTOM 2
#endif

/* xlabel command parameter */
extern struct xlabel_param XlabelParam;

int GpmWindow::GPM_xlabel()
{
  int    numer, orient = 0;
  float  rnumer[2] ;
  char  *ialpha[4];
  char   buf[512];
  int    hpos = 0, vpos = 0;
  int    stat;

  //regpm() ;

  rnumer[0] = XlabelParam.rnumer[0];
  rnumer[1] = XlabelParam.rnumer[1];
  ialpha[0] = XlabelParam.ialpha[0];
  ialpha[1] = XlabelParam.ialpha[1];
  ialpha[2] = XlabelParam.ialpha[2];
  ialpha[3] = XlabelParam.ialpha[3];
  numer     = XlabelParam.numer;
  if ( XlabelParam.argnum > 7) 
    orient    = XlabelParam.orient; /* string orientation */
  if ( XlabelParam.argnum > 8) 
    hpos      = XlabelParam.hpos; /* h-alignment */
  if ( XlabelParam.argnum > 9) 
    vpos      = XlabelParam.vpos; /* v-alignment */
  
  if ( ialpha[0] == NULL )
    return 2;

  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.fColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0 );
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  *buf='\0';
  
  if ((strcmp("times",ialpha[1])==0)||
      (strcmp("helvetica",ialpha[1])==0)||
      (strcmp("courier",ialpha[1])==0)) {
    
    if ((strcmp("bold",ialpha[2])==0)||(strcmp("medium",ialpha[2])==0)) {
      
      if (((strcmp("helvetica",ialpha[1])==0)||
	   (strcmp("courier",ialpha[1])==0))&&
	  (strcmp("i",ialpha[3])==0)) strcpy(ialpha[3],"o");
      
      if ((strcmp("times",ialpha[1])==0)&&(strcmp("o",ialpha[3])==0))
	strcpy(ialpha[3],"i");
      
      if ((strcmp(ialpha[3],"r")==0)||
	  (strcmp(ialpha[3],"i")==0)||
	  (strcmp(ialpha[3],"o")==0)) {
	
	switch ( numer ) {
	  
	case 8: case 10: case 11: case 12: case 14: case 17:
	case 18: case 20: case 24: case 25: case 34:
	  sprintf(buf,"-adobe-%s-%s-%s-normal--%d-*-*-*-*-*-iso8859-1",
		  ialpha[1],ialpha[2],ialpha[3],numer );
	  break;
	}
      }
    }
  }
  if (*buf=='\0')
    strcpy(buf,"-adobe-times-bold-r-normal--14-*-*-*-*-*-iso8859-1");
  myDrawString(ialpha[0],
	       (int)((rnumer[0]+mgraph.xorg)*mdev.ffx),
	       mdev.iyleng-(int)((rnumer[1]+mgraph.yorg)*mdev.ffy),
	       orient, hpos, vpos, buf);
  gflush();
  stat = gclose() ;

  return stat;
}

int GpmWindow::myDrawString( char *text, int x, int y,
							int orient, int hpos, int vpos, char *fontname )
{
  GdkGC         *local_gc, *agc, *bgc;
  GdkPixmap     *pixmap1, *pixmap2;
  GdkImage        *Image1, *Image2;
  GdkFont		*font;
  unsigned int  desc;
  unsigned long valuemask, pixel;
  GdkColor		white,black,backColor,foreColor,tmp_col;

  int  i, j, xoff=0, yoff=0;
  int  textwidth, textheight;
  int  drawwidth, drawheight;
  int  pix_x, pix_y, pre_x, pre_y;
  int  Cos = 0, Sin = 0;

    gdk_threads_enter();
  local_gc = gdk_gc_new (m_pixmap);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_copy(local_gc, gpm_gc);
    gdk_threads_leave();
    gdk_threads_enter();
  font = gdk_font_load( fontname );
    gdk_threads_leave();
    gdk_threads_enter();
  textwidth  = gdk_text_width( font, text, strlen(text));
    gdk_threads_leave();
  textheight = font->ascent + font->descent;
  desc       = font->descent;

  switch(orient%4) {
  default:
  case 0: /* normal left to right */
    drawwidth  = textwidth;
    drawheight = textheight;
    Cos = 1;
    Sin = 0;
    break;
  case 1: /* bottom to top */
    drawwidth  = textheight;
    drawheight = textwidth;
    Cos = 0;
    Sin = 1;
    break;
  case 2: /* right to left */
    drawwidth  = textwidth;
    drawheight = textheight;
    Cos = -1;
    Sin = 0;
    break;
  case 3: /* top to bottom */
    drawwidth  = textheight;
    drawheight = textwidth;
    Cos = 0;
    Sin = -1;
    break;
  }

  switch( hpos%3 ){
  case ALIGN_LEFT:
  default:
    xoff = textwidth/2;  break;
  case ALIGN_CENTER:  xoff = 0; break;
  case ALIGN_RIGHT:   xoff = -textwidth/2;   break;
  }
  switch( vpos%3 ){
  case ALIGN_TOP:
  default:
      yoff = textheight/2;   break;
  case ALIGN_MIDDLE:  yoff = 0; break;
  case ALIGN_BOTTOM:  yoff = - textheight/2; break;
  }

  x = x + xoff*Cos -yoff*Sin - drawwidth/2;
  y = y - xoff*Sin -yoff*Cos - drawheight/2;

    gdk_threads_enter();
  pixmap1 = gdk_pixmap_new(m_window->window, textwidth, textheight, -1);
    gdk_threads_leave();
    gdk_threads_enter();
  pixmap2 = gdk_pixmap_new(m_window->window, drawwidth, drawheight, -1);
    gdk_threads_leave();
    gdk_threads_enter();
  bgc = gdk_gc_new (pixmap1);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_set_foreground(bgc, /*&gpm_color[6]*/&black);
    gdk_threads_leave();
    gdk_threads_enter();
  agc = gdk_gc_new (pixmap1);
    gdk_threads_leave();
  tmp_col.pixel = 0xffffff;
    gdk_threads_enter();
  gdk_gc_set_foreground(agc, &tmp_col);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_draw_rectangle(pixmap1, agc, TRUE,
			0, 0, textwidth, textheight);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_draw_rectangle(pixmap2, bgc, TRUE,
			0, 0, drawwidth, drawheight);
    gdk_threads_leave();
  tmp_col.pixel = 0x0;
    gdk_threads_enter();
  gdk_gc_set_foreground(agc, &tmp_col);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_draw_string(pixmap1, font, agc, 0, font->ascent-1, text);
    gdk_threads_leave();
    gdk_threads_enter();
  Image1 = gdk_image_get(pixmap1, 0, 0, textwidth, textheight);
    gdk_threads_leave();
    gdk_threads_enter();
  Image2 = gdk_image_get(pixmap2, 0, 0, drawwidth, drawheight);
    gdk_threads_leave();

    for ( i=0 ; i<textwidth; i++ ) {
      for ( j=0 ; j<textheight; j++ ) {
    gdk_threads_enter();
#ifndef WIN32
	if (( pixel = gdk_image_get_pixel( Image1, i, j ) ) == 0 ) {
    gdk_threads_leave();
          continue;
	}
#else
	if (( pixel = gdk_image_get_pixel( Image1, i, j ) ) == 0xffffff ) {
    gdk_threads_leave();
          continue;
	}
#endif        
    gdk_threads_leave();
        pre_x = i - textwidth/2;
        pre_y = textheight/2 - j;
        
        pix_x = pre_x * Cos - pre_y * Sin;
        pix_y = pre_x * Sin + pre_y * Cos;
        
        pix_x += drawwidth/2;
        pix_y  = drawheight/2 - pix_y;
		if(pix_x >= 0 && pix_y >= 0) {
			if(pix_x < Image2->width && pix_y < Image2->height) {
    gdk_threads_enter();
    gdk_draw_point(m_pixmap/*drawable*/, gpm_gc, x+pix_x, y+pix_y);
    gdk_threads_leave();
			}
		}
      }
    }
    gdk_threads_enter();
  //gdk_gc_set_stipple(local_gc, pixmap2);
  gdk_gc_set_ts_origin(local_gc, x, y);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_set_fill(local_gc, GDK_STIPPLED);
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_set_function(local_gc, GDK_COPY);
    gdk_threads_leave();

    gdk_threads_enter();
  gdk_image_destroy( Image1 );
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_image_destroy( Image2 );
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_destroy( agc );
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_destroy( bgc );
    gdk_threads_leave();
    gdk_threads_enter();
  gdk_gc_destroy( local_gc );
    gdk_threads_leave();

  return 0;
}
