/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/draw.cpp,v 1.7 2005/04/06 08:42:15 orrisroot Exp $ */

/************************************************
*                                               *
*        DRAW LINE                              *
*                                               *
*************************************************
*                                               *
*        DRAW   C1, I2                          *
*-----------------------------------------------*
*                                               *
*        C1   :   X or Y                        *
*                                               *
*        I2   :  LEVEL                          *
*                                               *
*************************************************
*                                               *
*        T.KOBAYASHI         12/22/88           *
*                                               *
************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_draw(){
  char  *alpha;
  int   axis;
  float val, point, rmax, rmin, rleng;
  gpm_cont_t gpm_cont;

  /* LOAD SYSTEM PARAMETER */
  regpm(&gpm_cont);

  alpha =        GetString(0);
  val   = (float)GetScalar(1);
  
  /* SET PARAMETER */
  if(alpha == NULL)
    return 11; /* illegal axis type */
  switch(*alpha){
  case 'X':  axis = 0; break;
  case 'Y':  axis = 1; break;
  default:
    return 11; /* illegal axis type */
  }
  
  if(axis == 1){
    if(gpm_cont.axisType == 2 || gpm_cont.axisType == 3)
      val = (val > 0.0) ? (float)log10((double)val) : (float)-110.0;
    rleng = gpm_cont.ySize; /* spara.y_leng */
    switch(gpm_cont.axisType){
    case 3:
    case 2:
      rmax = (gpm_cont.yMax > 0.0) ?
        (float)log10(fabs((double)gpm_cont.yMax)) : (float)-100.0;
      rmin = (gpm_cont.yMin > 0.0) ?
        (float)log10(fabs((double)gpm_cont.yMin)) : (float)-100.0;
      if(rmax == rmin)
        rmin = (float)(rmax - 1.0);
      break;
    case 1: 
    case 0:
    default:
      rmax = gpm_cont.yMax;
      rmin = gpm_cont.yMin;
      break;
    }
  }else{
    if(gpm_cont.axisType == 1 || gpm_cont.axisType == 3)
      val = (val > 0.0) ? (float)log10((double)val) : (float)-110.0;
    rleng = gpm_cont.xSize;
    switch (gpm_cont.axisType){
    case 3:
    case 1:
      rmax = (gpm_cont.xMax > 0.0) ?
        (float)log10(fabs((double)gpm_cont.xMax)) : (float)-100.0;
      rmin = (gpm_cont.xMin > 0.0) ?
        (float)log10(fabs((double)gpm_cont.xMin)) : (float)-100.0;
      if(rmax == rmin)
        rmin = (float)(rmax - 1.0);
      break;
    case 2:
    case 0:
    default:
      rmax = gpm_cont.xMax;
      rmin = gpm_cont.xMin;
      break;
    }
  }

  /* DRAW LINE */
  if(val < rmin || val > rmax){
    printf("draw(): not draw line (over range).\n");
  }else{
    point = (val - rmin) / (rmax - rmin) * rleng;

    if(gopen(&gpm_cont, gpm_cont.paper, gpm_cont.orientation, gpm_cont.device,
             gpm_cont.paperWidth, gpm_cont.paperHeight) != 0)
      return 6; /* window does not exist */

    if(checktodvi(&gpm_cont) != 0)
      libgpm_dvi_write_param(&gpmdev_cont.dvi, gpm_cont.factor, 
                             gpm_cont.xOrigin, gpm_cont.yOrigin);
  
    gnewpen(gpm_cont.fColor);
    gpen(gpm_cont.fLineWidth, gpm_cont.fLineType, 0);
    gorigin(gpm_cont.xOrigin, gpm_cont.yOrigin);
    gfactor(gpm_cont.factor);

    if(axis == 0){
      gplot(point, 0.0, 0);
      gplot(point, gpm_cont.ySize, 2);
    }else{
      gplot(0.0, point, 0);
      gplot(gpm_cont.xSize, point, 2);
    }
    gflush();
    gclose();
  }
  
  wrgpm(&gpm_cont);
  return 0;
}

#ifdef __cplusplus
}
#endif
