/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/egraph.cpp,v 1.5 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"
#include "graph_sub.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_egraph(){
  int          dimx = 1, indexx[MAX_INDEX];
  int          dimy = 1, indexy[MAX_INDEX];
  int          axis_type, line_type, symbol_type, increment;
  char         *str1, *str2, time_freq_x = '?', time_freq_y = '?';
  float        **xdata, **ydata;
  float        **dat1, **dat2, tmp, maximum, minimum;
  float        dxMin, dxMax, dyMin, dyMax;
  float        xdlt, ydlt, *max, *min;
  float        center_symbol, rleng, rleng1;
  Buffer       *bufx, *bufy, *bufz, *bufx1, *bufy1;
  Buffer       *btmp, *btmp1, *btmp2, *bufz1;
  int          *indexz;
  int          length, is;
  register int i, j;
  gpm_cont_t   gpm_cont;

  /********* Load system parameter **********/
  regpm(&gpm_cont);
  
  /********* Get X-Y Data from SATELLITE Language *********/
  /* Get Y-Data */
  if(strcmp(GetArgType(0), "string") == 0){
    str1 = (char*)GetString(0);
    if(strlen(str1) == 1)
      time_freq_y = *str1;
    bufy = NULL;
  }else{
    bufy = (Buffer *)GetSeries(0, &dimy, indexy);
  }
  
  /* Get X-Data */
  if(strcmp(GetArgType(1), "string") == 0){
    str2 = (char*)GetString(1);
    if(strlen(str2) == 1)
      time_freq_x = *str2;
    bufx = NULL;
  }else{
    bufx = (Buffer*)GetSeries(1, &dimx, indexx);
  }
  
  if(bufx == NULL && bufy == NULL)
    return 8; /* illegal series object */

  if((bufx != NULL && dimx == 1 && bufy == NULL) ||
     (bufy != NULL && dimy == 1 && bufx == NULL) ||
     (bufx != NULL && bufy != NULL && dimx == 1 && dimy == 1))
    return 8; /* illegal series object */

  if((dimx > 2 && dimy > 2) || 
     (bufx != NULL && dimx == 2 && !(indexx[1] == 3 || indexx[1] == 2 ))||
     (bufy != NULL && dimy == 2 && !(indexy[1] == 3 || indexy[1] == 2 )))
    return 8; /* illegal series object */


  /********* Get Parameter from SATELLITE Language *********/
  axis_type     = (int)   GetScalar(2);
  line_type     = (int)   GetScalar(3);
  increment     = (int)   GetScalar(4);
  symbol_type   = (int)   GetScalar(5);
  center_symbol = (float) GetScalar(6);

  
  /********** Parameters Check *********/
  if(axis_type < GPM_AXIS_TYPE_RR || axis_type > GPM_AXIS_TYPE_SIZE)
    /* Log or Linear Axis */
    return 9; /* illegal axis type */

  if(axis_type != 0) 
    /* if type greater than 4, put on 0 */
    gpm_cont.axisType = (char)(axis_type % GPM_AXIS_TYPE_SIZE);
  /* if axis_type = 0, graph will be draw within scale command setting */
  
  gpmcmd_disp_scale_mode(gpm_cont.xMode, gpm_cont.yMode);
  
  if(symbol_type < 0 || symbol_type > 16) /* Set Center Symbol */
    return 10; /* illegal symbol number */

  /* Increment */
  increment = (increment <= 0) ? 1 : (short)increment;
  
  /* Length of Center Symbol */
  rleng = (center_symbol <= 0.0) ? (float)0.5 : center_symbol;
  
  /********** Data Check *********/
  if(bufx == NULL) {
    indexx[0] = indexy[0];
    bufx = (Buffer *)CAllocBuffer(indexx[0]);
    if(bufx == NULL)
      return 2; /* out of memory */
  }else if(bufy == NULL){
    indexy[0] = indexx[0];
    bufy = (Buffer *)CAllocBuffer(indexy[0]);
    if(bufy == NULL){
      FreeBuffer(bufy);
      return 2; /* out of memory */
    }
  }

  /*********** Set Y-Scale ***********/
  gpmcmd_set_data(time_freq_x, dimx, indexx, bufx);
  gpmcmd_set_data(time_freq_y, dimy, indexy, bufy);

  if(dimx == 1){
    dimx = 2;
    indexx[1] = 1;
  }
  if(dimy == 1){
    dimy = 2;
    indexy[1] = 1;
  }
  
  length = Min(indexx[0], indexy[0]);

  if(indexx[1] == 2 || indexy[1] == 2){
    if(indexx[1] == 2){
      bufz   = bufx;
      indexz = indexx;
    }else{
      bufz   = bufy;
      indexz = indexy;
    }
    indexz[1]++;
    
    btmp  = (Buffer*)CAllocBuffer(IndexSize(dimx,indexz));
    bufz1 = bufz +1;
    btmp1 = btmp +1;
    btmp2 = btmp +2;

    for(i = 0; i < length; i++){
      j = i*2;
      btmp [i*3] = bufz[j];
      btmp1[i*3] = bufz[j] - bufz1[j]; 
      btmp2[i*3] = bufz[j] + bufz1[j]; 
    }
    if(indexx[1] == 1){
      bufx1 = bufx;
      bufy1 = btmp;
    }else{
      bufx1 = btmp;
      bufy1 = bufy;
    }
  }else{
    bufx1 = bufx;
    bufy1 = bufy;
  }    

  /********* Memory Allocation for FLOAT DATA *********/
  xdata = (float**)emalloc( indexx[1] * sizeof(float*));
  for(i=0; i < indexx[1]; i++)
    xdata[i] = (float*)emalloc(indexx[0]*sizeof(float));
  
  ydata = (float**)emalloc(indexy[1]*sizeof(float*));
  for(i=0; i < indexy[1]; i++)
    ydata[i] = (float*)emalloc(indexy[0]*sizeof(float));
  
  gpmcmd_btof(dimx, indexx, bufx1, xdata); /* Buffer to Float */
  gpmcmd_btof(dimy, indexy, bufy1, ydata); /* Buffer to Float */

  is = (gpmcmd_zerop(indexx[1], xdata) &&
        ((gpm_cont.axisType == 1) || (gpm_cont.axisType == 3)))
    || (gpmcmd_zerop(indexy[1], ydata) &&
        ((gpm_cont.axisType == 2) || (gpm_cont.axisType == 3 )));
  
  if(indexx[1] == 1){
    dat1 = xdata;
    dat2 = ydata;
  }else{
    dat1 = ydata;
    dat2 = xdata;
  }
  min = dat2[1];
  max = dat2[2];
  
  gpmcmd_set_xscale(&gpm_cont, xdata, indexx[1], indexx[0], is);
  gpmcmd_set_yscale(&gpm_cont, ydata, indexy[1], indexy[0], is);
  
  /**********  GPM Window OPEN ***********/
  gpmcmd_open_window(&gpm_cont);
  gpmcmd_set_scale(&gpm_cont);
  
  gpmcmd_get_draw_scale(&gpm_cont, &dxMin, &dxMax, &dyMin, &dyMax);
  
  /**********   Drawing Loop   ********/
  if(line_type < 3 || line_type >= 6){
    xdlt = (dxMax - dxMin) / gpm_cont.xSize;
    ydlt = (dyMax - dyMin) / gpm_cont.ySize;
    rleng1 =  rleng / (float)2.0;
    if(indexx[1] == 1){
      for(j = is; j < length; j += (int)increment){
        tmp     = ( dat1[0][j] - dxMin ) / xdlt;
        maximum = ( max [j]    - dyMin ) / ydlt;
        minimum = ( min [j]    - dyMin ) / ydlt;
        gplot( tmp,          maximum, 0 );
        gplot( tmp,          minimum, 1 );
        gplot( tmp - rleng1, maximum, 0 );
        gplot( tmp + rleng1, maximum, 1 );
        gplot( tmp - rleng1, minimum, 0 );
        gplot( tmp + rleng1, minimum, 2 );
      }
    }else{
      for(j = is; j < length; j += (int)increment){
        tmp     = ( dat1[0][j] - dyMin ) / ydlt;
        maximum = ( max [j]    - dxMin ) / xdlt;
        minimum = ( min [j]    - dxMin ) / xdlt;
        gplot(maximum, tmp,         0 );
        gplot(minimum, tmp,         1 );
        gplot(maximum, tmp - rleng, 0 );
        gplot(maximum, tmp + rleng, 1 );
        gplot(minimum, tmp - rleng, 0 );
        gplot(minimum, tmp + rleng, 2 );
      }
    }
  }
  if(line_type < 6){
    ggraph(&xdata[0][is], &ydata[0][is], length - is, (int)increment,
           (int)line_type, (int)symbol_type, rleng);
  }
  
  printf("\n");
  gpmcmd_close_window();
  wrgpm(&gpm_cont);
  return 0;
}


#ifdef __cplusplus
}
#endif

