/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/frame.cpp,v 1.7 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_frame(){
  /* LOAD SYSTEM PARAMETER */
  gpm_cont_t gpm_cont;
  regpm(&gpm_cont);
  
  if(gopen(&gpm_cont, gpm_cont.paper, gpm_cont.orientation, gpm_cont.device, 
           gpm_cont.paperWidth, gpm_cont.paperHeight) != 0)
    return 6; /* window does not exist */

  if(checktodvi(&gpm_cont) != 0)
    libgpm_dvi_write_param(&gpmdev_cont.dvi, gpm_cont.factor, 
                           gpm_cont.xOrigin, gpm_cont.yOrigin);
  
  gnewpen(gpm_cont.fColor);
  gpen(gpm_cont.fLineWidth, gpm_cont.fLineType, 0);
  
  gfsize(gpm_cont.xSize, gpm_cont.ySize);
  gfactor(gpm_cont.factor);
  gorigin(gpm_cont.xOrigin, gpm_cont.yOrigin);
  
  gframe();
  gflush();
  gclose();
  wrgpm(&gpm_cont);
  return 0;
}

#ifdef __cplusplus
}
#endif
