/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/ginit.cpp,v 1.5 2005/04/06 08:42:15 orrisroot Exp $ */

/******************************************************
 *                                                    *
 *    INITIALIZE GRAPHIC PARAMETER                    *
 *                                                    *
 *      oritinal coded by T.Kobayashi (06/29/89)      *
 *                     by Y.Miyamoto  (03/13/91)      *
 *****************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_ginit(){
  int        i, j;
  gpm_cont_t gpm_cont;
  
  regpm(&gpm_cont);
  
  gpm_cont.factor       = 1.0;
  gpm_cont.xOrigin      = 20.0;
  gpm_cont.yOrigin      = 20.0;
  gpm_cont.xSize        = 100.0;
  gpm_cont.ySize        = 100.0;
  gpm_cont.fontType     = GPM_FONT_TYPE_TR;      /* times roman */
  gpm_cont.fLineWidth   = 0;
  gpm_cont.gLineWidth   = 0;
  gpm_cont.fLineType    = GPM_LINE_TYPE_SOLID;   /* solid */
  gpm_cont.gLineType    = GPM_LINE_TYPE_SOLID;   /* solid */
  gpm_cont.fColor       = GPM_COLOR_BLACK;       /* black */
  gpm_cont.gColor       = GPM_COLOR_BLACK;       /* black */

  gpm_cont.axisType     = GPM_AXIS_TYPE_RR;      /* real and real */
  gpm_cont.axisDraw     = GPM_AXIS_DRAW_LB;      /* integer and real */

  gpm_cont.xType        = GPM_SCALE_TYPE_LINEAR; /* linear */
  gpm_cont.yType        = GPM_SCALE_TYPE_LINEAR; /* linear */
  gpm_cont.zType        = GPM_SCALE_TYPE_LINEAR; /* linear */

  gpm_cont.xMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  gpm_cont.yMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  gpm_cont.zMode        = GPM_SCALE_MODE_AUTO;   /* auto */
  
  gpm_cont.xMin         = 0.0;
  gpm_cont.xMax         = 1.0;
  gpm_cont.yMin         = 0.0;
  gpm_cont.yMax         = 1.0;
  gpm_cont.zMin         = 0.0;
  gpm_cont.zMax         = 1.0;
  
  for (i = 0; i < GPM_ENV_MAX_TITLE; i++) {
    for (j = 0; j < GPM_ENV_MAX_TITLELEN; j++) {
      gpm_cont.title_x[i][j] = ' ';
      gpm_cont.title_y[i][j] = ' ';
      gpm_cont.title_z[i][j] = ' ';
    }
    gpm_cont.title_x[i][0] = '\0';
    gpm_cont.title_y[i][0] = '\0';
    gpm_cont.title_z[i][0] = '\0';
  }
  
  wrgpm(&gpm_cont);
  return 0;
}

#ifdef __cplusplus
}
#endif

