/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/gsolm_sub.cpp,v 1.4 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _gpm_gsolm_t {
  float  **a;
  int    **ia;
  int      ipen1, ipen2;

  float    ak1x, ak1y, alef, alow, amax, amin;
  float    arig, asig, aupp, bsig, dvd, eps;
  float    h, hib, hif, higb, higf, highq, hight, hori;
  
  int      i1, ias, ibas, idir, idis;
  int      ihid, iic, incr, ipen;
  int      isbl, iskr, itotal;
  int      ix, ixd, ixq, ixylm, iy, iyd, iyend, iyq, iysta;
  int      /*lcorn,*/ mesh, mxp1, myp1;

  float    px1, py1, rh, rv, trans, v, vert;
  float    xm, xorg, xp, xq, xshif, xshim;
  float    ym, yorg, yp, yq, yshif, yshim, ysmax, ysmin, ysq;
  void (*CPEN)(struct _gpm_gsolm_t *gs, double val);
  int  IPENMODE;
} gpm_gsolm_t;

static void   ting(gpm_gsolm_t *gs);
static void   ting_sub(gpm_gsolm_t *gs);
static void   ting_sub2(gpm_gsolm_t *gs);
static void   point_check(gpm_gsolm_t *gs);
static int    point_check_sub(gpm_gsolm_t *gs);
static void   pre1(gpm_gsolm_t *gs);
static void   pre2(gpm_gsolm_t *gs);
static void   point_draw(gpm_gsolm_t *gs);
static void   sub1(gpm_gsolm_t *gs);
static void   cpen1(gpm_gsolm_t *gs, double data);
static void   cpen2(gpm_gsolm_t *gs, double data);

static double sign(double val, double flag);

/***********************************************************************
 *****                   solm0r   Library List                     *****
 ***********************************************************************
 *                                                                     *
 *   Display of Solid Figure of Two variable , single valued function  *
 *   Defined on Rectangular Cordinate    z=f(x,y)                      *
 *   Mapping onto y-z Plane                                            *
 *                                                                     *
 ***********************************************************************
 *          C Version Rel. 1.0      1990/ 8/24      T.Kobayashi        *
 ***********************************************************************/
void gpmcmd_gsolm_solm0r(float **a2, int **ia2, int nx, int ny, int mx, int my,
                         float amxn[], float *rhv, int *ifunc, 
                         float xypl[2][2], int iipen1, int iipen2, int mode){
  gpm_gsolm_t gs;
  gs.CPEN     = mode ? cpen2 : cpen1;
  gs.IPENMODE = mode ? 2 : 1;

  gs.a = a2;
  gs.ia = ia2;
  gs.ipen1 = iipen1;
  gs.ipen2 = iipen2;
  
  gs.itotal = nx * ny;
  gs.iic = 0;
  gs.mxp1 = mx + 1;
  gs.myp1 = my + 1;
  gs.rh = rhv[0];
  gs.rv = rhv[1];
  gs.amin = amxn[0];
  gs.amax = amxn[1];
  if(gs.amax <= gs.amin){
    gs.trans = gs.amin;
    gs.amin = gs.amax;
    gs.amax = gs.trans;
  }
  if(gs.amax == gs.amin)
    gs.amax = gs.amin + 1.0f;
  gs.xorg = xypl[0][0];
  gs.yorg = xypl[0][1];
  gs.hori = xypl[1][0];
  gs.vert = xypl[1][1];
  
  gplot(gs.xorg, gs.yorg, 0);
  gs.ihid = ifunc[0];
  gs.ixylm = ifunc[1];
  gs.ibas = ifunc[2] + 1;
  
  if(gs.ibas < 1)
    gs.ibas = 1;
  if(gs.ibas > 3)
    gs.ibas = 3;
  
  if(fabs((double)gs.rh) >= 0.999)
    gs.rh = (float)sign(0.999, (double)gs.rh);
  if(fabs((double)gs.rv) >= 0.999)
    gs.rv = (float)sign(0.999, (double)gs.rv);
  if(fabs((double)gs.rh) <= 0.00001)
    gs.rh = (float)sign(0.00001, (double)gs.rh);
  gs.h = (gs.rh * (float)my /
          ((float)mx * (1.0f - (float)fabs((double)gs.rh))));
  if(gs.rh < 0.0){
    gs.alef = 0.0;
    gs.arig = (float)my - gs.h * (float)mx;
  }else{
    gs.alef = -gs.h * (float)mx;
    gs.arig = (float)my;
  }
  
  gs.v = (gs.rv * (gs.amax - gs.amin) /
          ((float)mx * (1.0f - (float)fabs((double)gs.rv))));
  if(gs.rv < 0.0){
    gs.aupp = (gs.amax - gs.amin) / (1.0f + gs.rv) + gs.amin;
    gs.alow = gs.amin;
  }else{
    gs.aupp = gs.amax;
    gs.alow = -((gs.amax - gs.amin) / (1.0f - gs.rv) - gs.amax);
  }
  
  gs.ak1x = gs.hori / (gs.arig - gs.alef);
  gs.ak1y = gs.vert / (gs.aupp - gs.alow);
  
  /***** Generation of Table  -ia- *****/
  if(gs.ihid != 0){
    for(gs.iy = 0; gs.iy < gs.myp1; gs.iy++)
      for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++)
        gs.ia[gs.ix][gs.iy] = 1;
  }else{                /* Hidden Line Proc */
    gs.mesh = 1;
    for(gs.iy = 0; gs.iy < gs.myp1; gs.iy++)
      for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++){
        gs.xm = (float)gs.ix;
        gs.ym = (float)gs.iy;
        gs.xshif = gs.ym - gs.h * gs.xm;
        gs.hight = gs.a[gs.ix][gs.iy];
        if(gs.hight < gs.amin)
          gs.hight = gs.amin;
        if(gs.hight > gs.amax)
          gs.hight = gs.amax;
        gs.yshif = gs.hight - gs.v * gs.xm;
        point_check(&gs);
        gs.ia[gs.ix][gs.iy] = gs.isbl;
      }
  }
  
  /***** Curve Ting *****/
  gs.mesh = 2;
  if(gs.ixylm != 2){
    gs.idir = 1;
    for(gs.iy = 0; gs.iy < gs.myp1; gs.iy++)
      for(gs.ix = 0; gs.ix < mx; gs.ix++){
        gs.ias = gs.ia[gs.ix][gs.iy] + gs.ia[gs.ix + 1][gs.iy];
        ting(&gs);
      }
  }
  if(gs.ixylm != 1){
    gs.idir = 2;
    for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++)
      for(gs.iy = 0; gs.iy < my; gs.iy++){
        gs.ias = gs.ia[gs.ix][gs.iy] + gs.ia[gs.ix][gs.iy + 1];
        ting(&gs);
      }
  }

  /***** Skirt Drawing *****/
  if(gs.ibas != 1 && gs.ihid == 0){
    if(mode)
      gnewpen(7); /* TODO check ! */
    if(gs.h < 0.0){
      gs.iskr = 1;
      gs.iy = 0;
      for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++){
        sub1(&gs);
      }
      gs.ix = gs.mxp1 - 1;
      
      if(gs.v * ((float)gs.ibas - 2.0) <= 0.0){
        gs.ixd = 0;
        gs.iyd = 0;
        gs.ipen = 0;
        if(gs.ibas == 3)
          gs.hight = gs.amax;
        else
          gs.hight = gs.amin;;
        pre2(&gs);
        point_draw(&gs);
        
        gs.ixd = gs.mxp1 - 1;
        gs.iyd = 0;
        gs.ipen = gs.IPENMODE;
        gs.CPEN(&gs, gs.a[gs.ix][gs.iy]);
        if(gs.ibas == 3)
          gs.hight = gs.amax;
        else
          gs.hight = gs.amin;;
        pre2(&gs);
        point_draw(&gs);
      }
      gs.iysta = 1;
      gs.iyend = gs.myp1;
    }else{
      gs.iysta = 0;
      gs.iyend = my;
    }
    
    gs.iskr = 2;
    gs.ix = gs.mxp1 - 1;
    for(gs.iy = gs.iysta; gs.iy < gs.iyend; gs.iy++){
      sub1(&gs);
    }
    gs.iy = gs.iyend - 1;
    
    if(gs.v * ((float)gs.ibas - 2.5) <= 0.0){
      gs.ixd = gs.mxp1 - 1;
      gs.iyd = 0;
      gs.ipen = 0;
      if(gs.ibas == 3)
        gs.hight = gs.amax;
      else
        gs.hight = gs.amin;
      pre2(&gs);
      point_draw(&gs);
      
      gs.ixd = gs.mxp1 - 1;
      gs.iyd = gs.myp1 - 1;
      gs.ipen = gs.IPENMODE;
      gs.CPEN(&gs, gs.a[gs.ix][gs.iy]);
      if(gs.ibas == 3)
        gs.hight = gs.amax;
      else
        gs.hight = gs.amin;
      pre2(&gs);
      point_draw(&gs);
    }
    if(gs.h > 0.0){
      gs.iskr = 3;
      gs.iy = gs.myp1 - 1;
      for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++){
        sub1(&gs);
      }
      gs.ix = gs.mxp1 - 1;
      
      if(gs.v * ((float)gs.ibas - 2.5) <= 0.0){
        gs.ixd = 0;
        gs.iyd = gs.myp1 - 1;
        gs.ipen = 0;
        if(gs.ibas == 3)
          gs.hight = gs.amax;
        else
          gs.hight = gs.amin;;
        pre2(&gs);
        point_draw(&gs);
        
        gs.ixd = gs.mxp1 - 1;
        gs.iyd = gs.myp1 - 1;
        gs.ipen = gs.IPENMODE;
        gs.CPEN(&gs, gs.a[gs.ix][gs.iy]);
        if(gs.ibas == 3)
          gs.hight = gs.amax;
        else
          gs.hight = gs.amin;;
        pre2(&gs);
        point_draw(&gs);
      }
    }
    if(gs.v * ((float)gs.ibas - 2.5) > 0.0){
      if(gs.ibas == 3)
        gs.hight = gs.amax;
      else
        gs.hight = gs.amin;;
      for(gs.ix = 0; gs.ix < gs.mxp1; gs.ix++){
        gs.ixd = gs.ix;
        gs.iyd = 0;
        gs.ipen = 0;
        
        pre2(&gs);
        point_draw(&gs);
        
        gs.ixd = gs.ix;
        gs.iyd = gs.myp1 - 1;
        gs.ipen = gs.IPENMODE;
        gs.CPEN(&gs, gs.a[gs.ix][gs.iy]);
        pre2(&gs);
        point_draw(&gs);
      }
      gs.ix = gs.mxp1 - 1;
      
      for(gs.iy = 0; gs.iy < gs.myp1; gs.iy++){
        gs.ixd = 0;
        gs.iyd = gs.iy;
        gs.ipen = 0;
        pre2(&gs);
        point_draw(&gs);
        
        gs.ixd = gs.mxp1 - 1;
        gs.iyd = gs.iy;
        gs.ipen = gs.IPENMODE;
        gs.CPEN(&gs, gs.a[gs.ix][gs.iy]);
        pre2(&gs);
        point_draw(&gs);
      }
    }
  }

  /***** Edge Line (Plotter Plane) Drawing *****/
  /*        if(lcorn == 0){
        gplot(0.0, 0.0, 0);
        gplot(0.0, vert, 1);
        gplot(hori, vert, 1);
        gplot(hori, 0.0, 1);
        gplot(0.0, 0.0, 1);
        } */
  gplot(gpmdev_cont.graph.xpre, gpmdev_cont.graph.ypre, 2);
}

/*************************
 ***** Ting Routine ******
 *************************/
static void ting(gpm_gsolm_t *gs){
  if(gs->ias == 0)
    return;
  if(gs->ias == 2){
    ting_sub2(gs);
    return;
  }
  gs->asig = 2.0f * ((float)gs->ia[gs->ix][gs->iy] - 0.5f);
  gs->dvd = 0.5f;
  gs->xm = (float)gs->ix;
  gs->ym = (float)gs->iy;
  switch(gs->idir){
  case 1:
    gs->xp = gs->xm + gs->dvd;
    gs->yp = gs->ym;
    gs->higf = gs->a[gs->ix + 1][gs->iy];
    break;
  case 2:
    gs->xp = gs->xm;
    gs->yp = gs->ym + gs->dvd;
    gs->higf = gs->a[gs->ix][gs->iy + 1];
    break;
  }
  gs->higb = gs->a[gs->ix][gs->iy];
  
  for(gs->i1 = 0; gs->i1 < 7; gs->i1++){
    if(gs->idir == 1){
      gs->hight = gs->higb + (gs->xp - gs->xm) * (gs->higf - gs->higb);
    }else{
      gs->hight = gs->higb + (gs->yp - gs->ym) * (gs->higf - gs->higb);
    }
    if(gs->hight < gs->amin)
      gs->hight = gs->amin;
    if(gs->hight > gs->amax)
      gs->hight = gs->amax;
    gs->xshif = gs->yp - gs->h * gs->xp;
    gs->yshif = gs->hight - gs->v * gs->xp;
    point_check(gs);
    
    gs->dvd = gs->dvd * 0.5f;
    gs->bsig = 2.0f * ((float)gs->isbl - 0.5f);
    if(gs->idir == 1){
      gs->xp = gs->xp + gs->bsig * (float)sign(gs->dvd, gs->asig);
    }else{
      gs->yp = gs->yp + gs->bsig * (float)sign(gs->dvd, gs->asig);
    }
  }
  
  if(gs->idir == 1){
    gs->hight = gs->higb + (gs->xp - gs->xm) * (gs->higf - gs->higb);
  }else{
    gs->hight = gs->higb + (gs->yp - gs->ym) * (gs->higf - gs->higb);
  }
  if(gs->hight < gs->amin)
    gs->hight = gs->amin;
  if(gs->hight > gs->amax)
    gs->hight = gs->amax;
  gs->xshim = gs->yp - gs->h * gs->xp;
  gs->yshim = gs->hight - gs->v * gs->xp;
  if(gs->asig < 0.0){
    gs->xshif = gs->xshim;
    gs->yshif = gs->yshim;
    gs->ipen = 0;
    point_draw(gs);
    ting_sub(gs);
    return;
  }
  if(((gs->idir == 1) && (gs->ix == 0)) || ((gs->idir == 2) && (gs->iy == 0))){
    gs->hight = gs->higb;
    if(gs->hight < gs->amin)
      gs->hight = gs->amin;
    if(gs->hight > gs->amax)
      gs->hight = gs->amax;
    gs->xshif = gs->ym - gs->h * gs->xm;
    gs->yshif = gs->hight - gs->v * gs->xm;
    gs->ipen = 0;
    point_draw(gs);
  }
  gs->xshif = gs->xshim;
  gs->yshif = gs->yshim;
  gs->ipen = gs->IPENMODE;
  gs->CPEN(gs, gs->a[gs->ix][gs->iy]);
  point_draw(gs);
}

static void ting_sub(gpm_gsolm_t *gs){
  gs->hight = gs->higf;
  if(gs->hight < gs->amin)
    gs->hight = gs->amin;
  if(gs->hight > gs->amax)
    gs->hight = gs->amax;
  if(gs->idir == 1){
    gs->xshif = gs->ym - gs->h * (gs->xm + 1.0f);
    gs->yshif = gs->hight - gs->v * (gs->xm + 1.0f);
  }else{
    gs->xshif = (gs->ym + 1.0f) - gs->h * gs->xm;
    gs->yshif = gs->hight - gs->v * gs->xm;
  }
  gs->ipen = gs->IPENMODE;
  gs->CPEN(gs, gs->a[gs->ix][gs->iy]);
  point_draw(gs);
}

static void ting_sub2(gpm_gsolm_t *gs){
  if(((gs->idir == 1) && (gs->ix == 0)) || ((gs->idir == 2) && (gs->iy == 0))){
    gs->ixd = gs->ix;
    gs->iyd = gs->iy;
    gs->ipen = 0;
    pre1(gs);
    pre2(gs);
    point_draw(gs);
  }
  if(gs->idir == 1){
    gs->ixd = gs->ix + 1;
    gs->iyd = gs->iy;
  }else{
    gs->ixd = gs->ix;
    gs->iyd = gs->iy + 1;
  }
  gs->ipen = gs->IPENMODE;
  gs->CPEN(gs, gs->a[gs->ix][gs->iy]);
  pre1(gs);
  pre2(gs);
  point_draw(gs);
}


/***** Search Cross Line and                       *****
 ***** Determine If Object Point is Visible or not *****/
static void point_check(gpm_gsolm_t *gs){
  gs->ysmin = 1.0e+10;
  gs->ysmax = -1.0e+10;
  gs->isbl = 1;
  if(gs->ixylm != 1){
    gs->idis = 1;
    for(gs->ixq = gs->ix + 1; gs->ixq < gs->mxp1; gs->ixq++){
      gs->xq = (float)gs->ixq;
      gs->yq = gs->xshif + gs->h * gs->xq;
      if(gs->yq < 0.0)
        break;
      gs->iyq = (int)gs->yq;
      if(gs->iyq >= gs->myp1 - 1)
        break;
      gs->eps = gs->yq - (float)gs->iyq;
      if(point_check_sub(gs) == -1)
        return;
    }
  }
  if(gs->ixylm == 2)
    return;
  gs->idis = 2;
  if(gs->h < 0.0){
    if(gs->mesh != 1 && gs->idir != 1){
      gs->iyq = gs->iy + 1;
      gs->incr = -1;
    }else{
      gs->iyq = gs->iy;
      gs->incr = -1;
    }
  }else{
    gs->iyq = gs->iy;
    gs->incr = 1;
  }
  
  while(1){
    gs->iyq = gs->iyq + gs->incr;
    if((gs->iyq < 0) || (gs->iyq >= gs->myp1))
      return;
    gs->yq = (float)gs->iyq;
    gs->xq = (gs->yq - gs->xshif) / gs->h;
    gs->ixq = (int)gs->xq;
    if(gs->ixq >= gs->mxp1 - 1)
      return;
    gs->eps = gs->xq - (float)gs->ixq;
    if(point_check_sub(gs) == -1)
      return;
  }
}

static int point_check_sub(gpm_gsolm_t *gs){
  gs->hib = gs->a[gs->ixq][gs->iyq];
  if(gs->idis == 1){
    gs->hif = gs->a[gs->ixq][gs->iyq + 1];
  }else{
    gs->hif = gs->a[gs->ixq + 1][gs->iyq];
  }
  gs->highq = gs->hib + gs->eps * (gs->hif - gs->hib);
  if(gs->highq < gs->amin)
    gs->highq = gs->amin;
  if(gs->highq > gs->amax)
    gs->highq = gs->amax;
  gs->ysq = gs->highq - gs->v * gs->xq;
  if(gs->ysq < gs->ysmin)
    gs->ysmin = gs->ysq;
  if(gs->ysq > gs->ysmax)
    gs->ysmax = gs->ysq;
  if(gs->ibas == 1){
    if((gs->ysmax > gs->yshif) && (gs->yshif > gs->ysmin)){
      gs->isbl = 0;
      return (-1);
    }
  }else if(gs->ibas == 2){
    if(gs->ysmax > gs->yshif){
      gs->isbl = 0;
      return (-1);
    }
  }else{
    if(gs->yshif > gs->ysmin){
      gs->isbl = 0;
      return (-1);
    }
  }
  return (0);
}


static void pre1(gpm_gsolm_t *gs){
  gs->hight = gs->a[gs->ixd][gs->iyd];
  if(gs->hight < gs->amin)
    gs->hight = gs->amin;
  if(gs->hight > gs->amax)
    gs->hight = gs->amax;
}


static void pre2(gpm_gsolm_t *gs){
  gs->xshif = (float)gs->iyd - gs->h * (float)gs->ixd;
  gs->yshif = gs->hight - gs->v * (float)gs->ixd;
}


static void point_draw(gpm_gsolm_t *gs){
  gs->px1 = gs->ak1x * (gs->xshif - gs->alef);
  gs->py1 = gs->ak1y * (gs->yshif - gs->alow);
  
  gplot(gs->px1, gs->py1, gs->ipen);
}


static void sub1(gpm_gsolm_t *gs){
  gs->ixd = gs->ix;
  gs->iyd = gs->iy;
  gs->ipen = 0;
  pre1(gs);
  pre2(gs);
  point_draw(gs);
  
  gs->ipen = gs->IPENMODE;
  gs->CPEN(gs, gs->a[gs->ix][gs->iy]);
  if(gs->ibas == 3)
    gs->hight = gs->amax;
  else
    gs->hight = gs->amin;;
  pre2(gs);
  point_draw(gs);
}


static void cpen1(gpm_gsolm_t *gs, double data){
  if(data < 0.0)
    gnewpen(gs->ipen1);
  else
    gnewpen(gs->ipen2);
}


static void cpen2(gpm_gsolm_t *gs, double data){
  double  level = (data - gs->amin) / (gs->amax - gs->amin);
  grainbow(level);
}


static double sign(double val, double flag){
  return (flag < 0.0) ? (-1.0 * val) : (val);
}

#ifdef __cplusplus
}
#endif
