/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/label.cpp,v 1.9 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#define LBL_LEN   1024

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_label(){
  int   ilen, dmode;
  char  in[LBL_LEN];
  char  *imode, *lbl_str, *file_check;
  int   type;
  double high, xorg, yorg, xpos, ypos, theta, co, si;
  FILE  *fpi;
  gpm_cont_t gpm_cont;

  memset(in, 0, LBL_LEN);

  /*** LOAD SYSTEM PARAMETER ***/
  regpm(&gpm_cont);

  imode   = GetString(0);
  xorg    = GetScalar(1);
  yorg    = GetScalar(2);
  high    = GetScalar(3);
  theta   = GetScalar(4);
  lbl_str = GetString(5);
  dmode   = (int)GetScalar(6);

  /*************************************
    "I" : STRING PARAMETER 5
    "F" : STRING FILE
    **************************************/

  switch(*imode){
  case 'f':
  case 'F': 
    type = 'f'; break;
  case 'i':
  case 'I':
  default:
    type = 'i';
  }
  
  xpos = xorg;
  ypos = yorg;
  
  if(lbl_str == NULL)
    return 3; /* illegal parameter */
  
  if(type == 'f'){  /* input from FILE */
    fpi = fopen(lbl_str, "r");
    if(fpi == NULL)
      return 7; /* file not found */
    file_check = fgets(in, LBL_LEN, fpi);
    if(gopen(&gpm_cont, gpm_cont.paper, gpm_cont.orientation, gpm_cont.device, 
             gpm_cont.paperWidth, gpm_cont.paperHeight) != 0)
      return 6; /* window does not exit */
    if(checktodvi(&gpm_cont) != 0)
      libgpm_dvi_write_param(&gpmdev_cont.dvi, gpm_cont.factor, 
                             gpm_cont.xOrigin, gpm_cont.yOrigin);
    gfactor(gpm_cont.factor);
    gnewpen(gpm_cont.fColor);
    gfont(gpm_cont.fontType);
    gpen(gpm_cont.fLineWidth, gpm_cont.fLineType, 0 );

    co = cos((double)theta/180*M_PI);
    si = sin((double)theta/180*M_PI);

    while(file_check != NULL){
      ilen = (int)strlen(in);
      if (ilen > 0 && in[ilen - 1] == '\n'){
        in[ilen] = '\0';
        --ilen;
      }
      gorigin(gpm_cont.xOrigin, gpm_cont.yOrigin);
      glabel(xpos, ypos, in, high, theta, dmode, NULL);
      xpos = xpos + high*1.2*si;
      ypos = ypos - high*1.2*co;
      file_check = fgets(in, LBL_LEN, fpi);
    }
    gflush();
    gclose();
    fclose(fpi);
  }else{
    if(strlen(lbl_str) == 0 || (strlen(lbl_str) == 1 && lbl_str[0] == ' ' ))
      return 0; /* success - but empty string */
    if(gopen(&gpm_cont, gpm_cont.paper, gpm_cont.orientation, gpm_cont.device, 
             gpm_cont.paperWidth, gpm_cont.paperHeight) != 0)
      return 6; /* window does not exit */
    if(checktodvi(&gpm_cont) != 0)
      libgpm_dvi_write_param(&gpmdev_cont.dvi, gpm_cont.factor, 
                             gpm_cont.xOrigin, gpm_cont.yOrigin);
    gfactor(gpm_cont.factor);
    gnewpen(gpm_cont.fColor);
    gpen(gpm_cont.fLineWidth, gpm_cont.fLineType, 0 );
    gorigin(gpm_cont.xOrigin, gpm_cont.yOrigin);
    gfont(gpm_cont.fontType);
    glabel(xpos, ypos, lbl_str, high, theta, dmode, NULL);
    gflush();
    gclose();
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
