/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/ldata.cpp,v 1.3 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"
#include "ldata.h"

#ifdef __cplusplus
extern "C" {
#endif

float **gpmcmd_ldata_ldata(int bufno, int nx, int ny, char *timeaxis, 
                           int viewpoint){
  register int i;
  int    dim2, index2[MAX_INDEX], index[2];
  int    siz, ix, iy;
  Buffer *work;
  float  **buf;
  
  if((work = ReadBuffer(bufno, &dim2, index2)) == NULL) 
    return NULL;
  siz = IndexSize(dim2, index2);
  
  buf = (float**)gpmcmd_ldata_malloc2d(nx, ny, sizeof(float));

  if(*timeaxis == 'X' || *timeaxis == 'x'){
    for(i = 0; i < siz; i++){
      rIndex(i, index, dim2, index2);
      ix = index[0];
      iy = index[1];
      if(viewpoint < 0)
        iy = ny - iy - 1;
      buf[ix][iy] =  (float)work[i];
    }
  }else{
    for(i = 0; i < siz; i++){
      rIndex(i, index, dim2, index2);
      ix = index[1];
      iy = index[0];
      if(viewpoint < 0)
        iy = ny - iy - 1;
      buf[ix][iy] =  (float)work[i];
    }
  }
  FreeBuffer(work);
  return  buf;
}


void gpmcmd_ldata_thinout(float **buf, int *nx, int *ny, int xdiv, int ydiv){
  register int  i, j;
  /* mabiki */
  *nx = (*nx-1) / xdiv + 1;
  *ny = (*ny-1) / ydiv + 1;
  for(i = 0; i < *nx; i++){ 
    for(j = 0; j < *ny; j++){
      buf[i][j] = buf[i*xdiv][j*ydiv];
    }
  }
}

char **gpmcmd_ldata_malloc2d(int nx, int ny, size_t siz){
  register int i;
  char       **f = (char**)emalloc(sizeof(char*) * nx);
  for(i = 0; i < nx; i++) 
    f[i] = (char*)emalloc(siz * ny);
  return f;
}

#ifdef __cplusplus
}
#endif
