/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/ltype.cpp,v 1.4 2005/04/06 08:42:15 orrisroot Exp $ */

/*************************************************
 *                                               *
 *              SET LINE TYPE                    *
 *                                               *
 *     ltype(I1, I2)                             *
 *                                               *
 *        I1   : GRAPH LINE TYPE                 *
 *        I2   : FRAME LINE TYPE                 *
 *                                               *
 *      original coded by T.KOBAYASHI 12/03/1988 *
 *                                               *
 ************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_ltype(){
  int    i1, i2;
  gpm_cont_t gpm_cont;

  regpm(&gpm_cont);

  i1 = (int)GetScalar(0) -1;
  i2 = (int)GetScalar(1) -1;
  
  if( i1 < 0 || i1 > 7)
    return 3; /* illegal parameter */
  if( i2 < 0 || i2 > 7)
    return 3; /* illegal parameter */
  
  gpm_cont.gLineType = i1;
  gpm_cont.fLineType = i2;
  
  wrgpm(&gpm_cont);
  return 0;
}

#ifdef __cplusplus
}
#endif
