#/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/scale.cpp,v 1.7 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

static int sc_type(char *s){
  int type = -1;
  if     (*s == 'N') type = 0;
  else if(*s == 'L') type = 1;
  return type;
}


static int sc_mode(char *s){
  int mode = -1;
  if     (*s == 'A') mode = 1;
  else if(*s == 'F') mode = 2;
  else if(*s == 'D') mode = 3;
  return mode;
}

static int token_s(int *r_code, double *rnum){
  char  str[40];
  if(sl4_getstr(str,40) == NULL) {
    return -1;
  }
  if(strlen(str) == 0)
    *r_code = 2;
  else
    *r_code = sscanf(str, "%lf", rnum);
  return 0;
}

static int set_minmax(char str, int arg, int narg, double mind, double maxd,
                      float *min, float *max){
  int    itype;
  double rnum;
  while(1){
    if(narg > arg){
      *min = (float)mind;
    }else{
      printf("%c -- MIN = %f    ", str, *min);
      if(token_s(&itype, &rnum) != 0) return -1;
      if(itype == 1)
        *min = (float)rnum;
    }
    if(narg > arg+1){
      *max = (float)maxd;
    }else{
      printf("%c -- MAX = %f    ", str, *max);
      if(token_s(&itype, &rnum) != 0) return -1;
      if(itype == 1)
        *max = (float)rnum;
    }
    if(*min < *max){
      break;
    }else{
      arg = narg;
    }
  }
  return 0;
}
  
  
DLLEXPORT int mod_gpm_scale(){
  int     i, check, zflag, args, flag = 0;
  int     ityp[3], iscl[3], needs[3];
  float   *min[3], *max[3];
  float   rnumer[6], tmp;
  char   *ialpha[6], *atype[6];
  static char str[] = { 'X', 'Y', 'Z' };
  gpm_cont_t gpm_cont;
  
  /***** Load System Parameter *****/
  regpm(&gpm_cont);
  
  for(i=0; i<6; i++)
    rnumer[i] = 0.0;
  /***** Get Parameter *****/
  args = GetArgNum();
  for(i=0; i < args && i < 6; i++){
    atype [i] = GetArgType(i);
    ialpha[i] = GetString(i);
  } 
  zflag = (args >= 6) ? (!strcmp(atype[4],"string")) : 0;

  for(i=0; i < 6; i++)
    rnumer[i] = 0.0;
  
  if(!zflag){
    if(args >= 6){
      rnumer[0] = rnumer[2] = (float)GetScalar(4);
      rnumer[1] = rnumer[3] = (float)GetScalar(5);
      if(args > 6){
        rnumer[2] = (float)GetScalar(6);
        rnumer[3] = (float)GetScalar(7);
      }
    }
  }else{
    if(args >= 8){
      rnumer[0] = rnumer[2] = rnumer[4] = (float)GetScalar(6);
      rnumer[1] = rnumer[3] = rnumer[5] = (float)GetScalar(7);
      if(args >= 10){
        rnumer[2] = rnumer[4] = (float)GetScalar(8);
        rnumer[3] = rnumer[5] = (float)GetScalar(9);
        if(args > 10){
          rnumer[4] = (float)GetScalar(10);
          rnumer[5] = (float)GetScalar(11);
        }
      }
    }
  }
  
  /***** Set Parameter *****/
  check = sc_type(ialpha[0]);
  if(check == -1)
    return 3; /* illegal parameter */
  ityp[0] = gpm_cont.xType = check;
  
  check = sc_type(ialpha[2]);
  if(check == -1)
    return 3; /* illegal parameter */
  ityp[1] = gpm_cont.yType = check;
  
  check = sc_mode(ialpha[1]);
  iscl[0] = check;
  if(check == -1)
    return 3; /* illegal parameter */
  
  check = sc_mode(ialpha[3]);
  if(check == -1)
    return 3; /* illegal parameter */
  iscl[1] = check;

  if(zflag){
    check =  sc_type(ialpha[4]);
    if(check == -1)
      return 3; /* illegal parameter */
    ityp[2] = gpm_cont.zType = check;
    check = sc_mode(ialpha[5]);
    if(check == -1)
      return 3; /* illegal parameter */
    iscl[2] = check;
  }else{
    ityp[2] = gpm_cont.zType;
    iscl[2] = gpm_cont.zMode ? 3 : 1;
  }

  gpm_cont.xMode    = ( iscl[0] == 1 ) ? 0 : 1 ;
  gpm_cont.yMode    = ( iscl[1] == 1 ) ? 0 : 1 ;
  gpm_cont.zMode    = ( iscl[2] == 1 ) ? 0 : 1 ;
  gpm_cont.axisType = ityp[1]*2 + ityp[0];
  
  needs[0] = (zflag)? 6: 4;
  needs[1] = needs[0]+(iscl[0]==2)*2;
  needs[2] = needs[0]+(iscl[0]==2)*2+(iscl[1]==2)*2;
  
  if(iscl[0]*iscl[1]*iscl[2] != 1){
    
    /***** Set Scale Data *****/
    min[0] = &(gpm_cont.xMin);
    max[0] = &(gpm_cont.xMax);
    min[1] = &(gpm_cont.yMin);
    max[1] = &(gpm_cont.yMax);
    min[2] = &(gpm_cont.zMin);
    max[2] = &(gpm_cont.zMax);
    
    /***** Set Scale Data *****/
    for(i=0; i < 3;){
      if(ityp[i] == 1 && iscl[i] != 3 && flag == 0){
        *min[i] = (float)((*min[i] > 0.0 ) ? log10((double)*min[i]) : -1.0);
        *max[i] = (float)((*max[i] > 0.0 ) ? log10((double)*max[i]) :  0.0);
        if(*min[i] == *max[i])
          *min[i] = (float)(*max[i] - 1.0);
        if(*min[i] > *max[i]){
          tmp = *min[i]; *min[i] = *max[i]; *max[i] = tmp;
        }
      }
      if(iscl[i] == 2){
        if(set_minmax(str[i], needs[i], args, rnumer[i*2], rnumer[i*2+1],
                      min[i], max[i]) == -1){
          return 99; /* interrupt by user */
        }
      }
      if(ityp[i] == 1 && iscl[i] != 3){
        if(fabs((double)*max[i]) < 38.0 && fabs((double)*min[i]) < 38.0){
          *max[i] = (float)pow(10.0,(double)*max[i]);
          *min[i] = (float)pow(10.0,(double)*min[i]);
          flag = 0;
        }else{
          flag = -1;
          if(args >= needs[i]){
            if(fabs(*max[i]) > 37.0)
              printf("*** 10^(%g) is out of domain of Log scale.\n", *max[i]);
            if(fabs(*min[i]) > 37.0)
              printf("*** 10^(%g) is out of domain of Log scale.\n", *min[i]);
            return 3; /* illegal parameter */
          }
        }
      }
      if(flag == 0)
        i++;
    }
  }  
  wrgpm(&gpm_cont);
  return 0;
}

#ifdef __cplusplus
}
#endif
