/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/gpm/command/wclose.cpp,v 1.6 2005/04/06 08:42:15 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libgpm.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_gpm_wclose(){
  int    i, argc, wnum;
  char  *str;
  gpm_cont_t gpm_cont;
  argc = GetArgNum();
  if(argc != 1)
    return 3; /* illegal parameter */

  /* get closing window number */
  wnum = 0;
  if(strcmp(GetArgType(0), "scalar") == 0){
    wnum = (int)GetScalar(0);
    if(wnum <= 0 || wnum >GPM_ENV_MAX_WIN)
      return 3; /* illegal papameter */
  }else if(strcmp(GetArgType(0), "string") == 0){
    str = GetString(0);
    if(str == NULL)
      return 3; /* illegal parameter */
    if(strcmp(str, "ALL") != 0)
      return 3; /* illegal parameter */
    wnum = 0; /* special number of window */
  }else{
    return 3; /* illegal parameter */
  }
  if(wnum == 0){
    for(i=1; i<=GPM_ENV_MAX_WIN; i++){
      if(libgpm_window_close(&gpm_cont, i) == -1)
        return 1; /* fatal error */
    }
  }else{
    int code;
    code = libgpm_window_close(&gpm_cont, wnum);
    if(code == -1)
      return 1; /* fatal error */
    if(code == 1){
      printf("Not exist windw (No.%d)\n", wnum);
      /* return 6; */ /* window does not exist */
    }
  }
  return 0;
}

#ifdef __cplusplus
}
#endif

