@echo off

REM
REM gpm2eps - create eps file from GPM dvifile
REM

REM Copyright (c) 2003-2004
REM RIKEN (The Institute of Physical and Chemical Research)
REM All rights reserved.
REM
REM Redistribution and use in source and binary forms, with or without
REM modification, are permitted provided that the following conditions
REM are met:
REM
REM 1. Redistributions of source code must retain the above copyright
REM    notice, this list of conditions and the following disclaimer.
REM
REM 2. Redistributions in binary form must reproduce the above copyright
REM    notice, this list of conditions and the following disclaimer in the
REM    documentation and/or other materials provided with the distribution.
REM
REM THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
REM EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
REM IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
REM PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
REM LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
REM CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
REM SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
REM INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
REM CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
REM ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
REM THE POSSIBILITY OF SUCH DAMAGE.

REM $SATELLITE: satellite4/modules/gpm/gpm2ps/gpm2eps.bat,v 1.4 2004/09/02 08:18:21 orrisroot Exp $

if /%1/==/--help/ (goto print_usage)

set PS2EPSI=
for %%i in (.;%PATH%) do if exist "%%i\ps2epsi.bat" set PS2EPSI=%%i\ps2epsi.bat
if not /%PS2EPSI%/==// goto SETGPM2PS
echo %0 : Error - "ps2epsi.bat" command required 1>&2
goto errorquit1

:SETGPM2PS

set PSFILE=_tmp_SL4_GPM2PS.ps
set EPSFILE=_tmp_SL4_GPM2EPS.eps
if exist %PSFILE%  del /f %PSFILE%
if exist %EPSFILE% del /f %EPSFILE%

set GPM2PS=%~p0\gpm2ps.exe
if exist "%GPM2PS%" goto CREATE_PS
echo %0 : Error - "gpm2ps.exe" command required 1>&2
goto errorquit1

:CREATE_PS

echo GPM to PS: 1>&2
"%GPM2PS%" %1 %2 %3 %4 %5 %6 %7 %8 %9 > %PSFILE%
if /%ERRORLEVEL%/==/0/ goto CREATE_EPS
if exist %PSFILE%  del /f %PSFILE%
goto errorquit1

:CREATE_EPS

echo PS to EPS: 1>&2
call "%PS2EPSI%" %PSFILE% %EPSFILE% 1>&2 NULL
REM unset GS local environment
set infile=
set outfile=
set GS=
set GSC=

type %EPSFILE%
if exist %PSFILE%  del /f %PSFILE%
if exist %EPSFILE% del /f %EPSFILE%

goto end

:errorquit1
set PS2EPSI=
set GPM2PS=
set PSFILE=
set EPSFILE=
exit /b 1

:print_usage
echo;
echo %0 : Create EPS file from GPM dvifile. 
echo;
echo Usage: %0 [arguments] [file]
echo;
echo Arguments:
echo   -rv         Use reverse colors mode
echo   -cps        Output color postscript
echo   -tray       Append tray set information
echo;
echo Copyright (c) 2003-2004
echo RIKEN (The Institute of Physical and Chemical Research)
echo All rights reserved.
echo;
set PS2EPSI=
set GPM2PS=
set PSFILE=
set EPSFILE=
exit /b 65

:end
echo done. 1>&2
set PS2EPSI=
set GPM2PS=
set PSFILE=
set EPSFILE=
exit /b 0;
