/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: gpmwinpriv.h,v 1.12 2005/10/29 10:18:55 orrisroot Exp $ */

#ifndef _GPM_WINDOW_PRIV_H_
#define _GPM_WINDOW_PRIV_H_

#ifdef __cplusplus
extern "C" {
#endif

/* main.c */
int  gpmwin_comm_command();

/* x11.c / win32.c */
int gpmwin_init(int argc, char *argv[]);
int gpmwin_create(int x, int y, const char *title);
int gpmwin_mainloop();
int gpmwin_quit();
int gpmwin_getwattr(int *w, int *h);
int gpmwin_flush();
int gpmwin_erase();
int gpmwin_resize(const char *title, int w, int h);
int gpmwin_setcolor(int color, int rainbow);
int gpmwin_setdash(int itype, int isize, int imode);
int gpmwin_drawrect(int x, int y, int w, int h);
int gpmwin_fillrect(int x, int y, int w, int h);
int gpmwin_drawpoint(gpm_xpoint_t *ps, int npts);
int gpmwin_drawline(gpm_xpoint_t *ps, int npts);
int gpmwin_fillpoly(gpm_xpoint_t *ps, int npts);
int gpmwin_drawarc(int x, int y, int w, int h, int a1, int a2); 
int gpmwin_fillarc(int x, int y, int w, int h, int a1, int a2); 
int gpmwin_gradation(int color, int n, double level);

#ifdef __cplusplus
}
#endif

#endif  /* _GPM_WINDOW_PRIV_H_ */
