/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: comm-win32.c,v 1.5 2005/10/30 09:55:30 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WIN32
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "libgpm.h"
#include "libgpmpriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/* #define DEBUG_COMM_WIN32_C 1 */

#ifdef WIN32

void libgpm_comm_server_init(){
  HANDLE rfd,wfd;
  rfd = GetStdHandle(STD_INPUT_HANDLE);
  wfd = GetStdHandle(STD_OUTPUT_HANDLE);
  gpm_window_context.fd[0] = rfd;
  gpm_window_context.fd[1] = wfd;
}

static int libgpm_comm_send(int type, const void *ptr, size_t len);

int libgpm_comm_send_int(int i){
  return libgpm_comm_send(LIBGPM_COMM_TYPE_INT, &i, sizeof(int));
}

int libgpm_comm_send_float(double d){
  return libgpm_comm_send(LIBGPM_COMM_TYPE_FLOAT, &d, sizeof(double));
}

int libgpm_comm_send_str(const char *s, size_t len){
  return libgpm_comm_send(LIBGPM_COMM_TYPE_STRING, s, len);
}

int libgpm_comm_recive_int(int *i){
  int rtype;
  DWORD rlen;

#ifdef DEBUG_COMM_WIN32_C
  DWORD ftype;
  ftype = GetFileType(gpm_window_context.fd[0]);
  switch(ftype){
  case FILE_TYPE_UNKNOWN:
    MessageBox(NULL,"FILE_TYPE_UNKNOWN","Error",MB_OK); break;
  case FILE_TYPE_DISK:
    MessageBox(NULL,"FILE_TYPE_DISK","Error",MB_OK); break;
  case FILE_TYPE_CHAR:
    MessageBox(NULL,"FILE_TYPE_CHAR","Error",MB_OK); break;
  default:
    break;
  }
#endif

  if(ReadFile(gpm_window_context.fd[0], &rtype, sizeof(int), &rlen, NULL) == FALSE)
    return -1;
  if(rtype != LIBGPM_COMM_TYPE_INT)
    return -1;
  if(ReadFile(gpm_window_context.fd[0], i, sizeof(int), &rlen, NULL) == FALSE)
    return -1;
  return 0;
}

int libgpm_comm_recive_float(double *d){
  int rtype;
  DWORD rlen;

#ifdef DEBUG_COMM_WIN32_C
  DWORD ftype;
  ftype = GetFileType(gpm_window_context.fd[0]);
  switch(ftype){
  case FILE_TYPE_UNKNOWN:
    MessageBox(NULL,"FILE_TYPE_UNKNOWN","Error",MB_OK); break;
  case FILE_TYPE_DISK:
    MessageBox(NULL,"FILE_TYPE_DISK","Error",MB_OK); break;
  case FILE_TYPE_CHAR:
    MessageBox(NULL,"FILE_TYPE_CHAR","Error",MB_OK); break;
  default:
    break;
  }
#endif

  if(ReadFile(gpm_window_context.fd[0], &rtype, sizeof(int), &rlen, NULL) == FALSE)
    return -1;
  if(rtype != LIBGPM_COMM_TYPE_FLOAT)
    return -1;
  if(ReadFile(gpm_window_context.fd[0], d, sizeof(double), &rlen, NULL) == FALSE)
    return -1;
  return 0;
}

int libgpm_comm_recive_str(char *s, size_t blen, size_t *rlen){
  int rtype;
  size_t i;
  char c;
  DWORD _rlen;

#ifdef DEBUG_COMM_WIN32_C
  DWORD ftype;
  ftype = GetFileType(gpm_window_context.fd[0]);
  switch(ftype){
  case FILE_TYPE_UNKNOWN:
    MessageBox(NULL,"FILE_TYPE_UNKNOWN","Error",MB_OK); break;
  case FILE_TYPE_DISK:
    MessageBox(NULL,"FILE_TYPE_DISK","Error",MB_OK); break;
  case FILE_TYPE_CHAR:
    MessageBox(NULL,"FILE_TYPE_CHAR","Error",MB_OK); break;
  default:
    break;
  }
#endif

  if(ReadFile(gpm_window_context.fd[0], &rtype, sizeof(int), &_rlen, NULL) == FALSE)
    return -1;
  if(rtype != LIBGPM_COMM_TYPE_STRING)
    return -1;
  if(ReadFile(gpm_window_context.fd[0], rlen, sizeof(size_t), &_rlen, NULL) == FALSE)
    return -1;
  for(i=0; i<*rlen; i++){
    if(ReadFile(gpm_window_context.fd[0], &c, 1, &_rlen, NULL) == FALSE)
      return -1;
    if(i < blen){
      *s = c; s++;
    }
  }
  return 0;
}

static int libgpm_comm_send(int type, const void *ptr, size_t len){
  DWORD wlen;

#ifdef DEBUG_COMM_WIN32_C
  DWORD ftype;
  ftype = GetFileType(gpm_window_context.fd[1]);
  switch(ftype){
  case FILE_TYPE_UNKNOWN:
    MessageBox(NULL,"FILE_TYPE_UNKNOWN","Error",MB_OK); break;
  case FILE_TYPE_DISK:
    MessageBox(NULL,"FILE_TYPE_DISK","Error",MB_OK); break;
  case FILE_TYPE_CHAR:
    MessageBox(NULL,"FILE_TYPE_CHAR","Error",MB_OK); break;
  default:
    break;
  }
#endif

  if(WriteFile(gpm_window_context.fd[1], &type, sizeof(int), &wlen, NULL) == FALSE)
    return -1;
  if(type == LIBGPM_COMM_TYPE_STRING)
    if(WriteFile(gpm_window_context.fd[1], &len, sizeof(size_t), &wlen, NULL) == FALSE){
      return -1;
    }
  if(WriteFile(gpm_window_context.fd[1], ptr, (DWORD)len, &wlen, NULL) == FALSE){
    return -1;
  }
  return 0;
}

#endif /* WIN32 */

#ifdef __cplusplus
}
#endif
