/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: libgpmpriv.h,v 1.19 2005/10/30 09:55:30 orrisroot Exp $ */

#ifndef _LIBGPM_PRIVATE_H_
#define _LIBGPM_PRIVATE_H_

#ifdef EXTERN
# undef EXTERN
#endif

#ifdef  _LIBGPM_GLOBAL_VARS_
# define EXTERN
#else
# define EXTERN extern
#endif /* _LIBGPM_GROBAL_VARS_ */

#define LIBGPM_COMM_TYPE_INT     0
#define LIBGPM_COMM_TYPE_FLOAT   1
#define LIBGPM_COMM_TYPE_STRING  2

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _gpm_window_context_t {
  int   pid;
#ifdef WIN32
  HANDLE fd[2];
#else
  int   fd[2];
#endif
} gpm_window_context_t;


typedef RETSIGTYPE (*sigfunc_t)(int);

typedef struct _gpm_child_controller_t {
  int pid;
#ifdef WIN32
  HANDLE pifd[2], pofd[2]; /* I/O pipe file dscripters of parent process */
  HANDLE hProc;
#else
  int pifd[2], pofd[2]; /* I/O pipe file dscripters of parent process */
#endif
  sigfunc_t sig_int, sig_term, sig_quit;
} gpm_child_controller_t;

/* for GPM WINDOW */
EXTERN gpm_window_context_t gpm_window_context;

/* context.c */
int regpm2(gpm_cont_t *cont, int num);
int wrgpm2(gpm_cont_t *cont, int num);
int libgpm_context_read_win(int num);
int libgpm_context_write_win(int num);
int libgpm_context_close_win(int num);

/* fontsize.c */
double getfontwidth(int c, double length, int font);
double getstrwidth(const char *str, double height, int font);

/* proc-unix.c  or proc-win32.c */
int libgpm_process_control_init(gpm_child_controller_t *childcntl);
int libgpm_process_control_clean(gpm_child_controller_t *childcntl);
int libgpm_process_create(const char *bin, gpm_child_controller_t *childcntl);
int libgpm_process_wait(int pid, int *status);

/* comm-unix.c or comm-win32.c */
void libgpm_comm_server_init();
int  libgpm_comm_window_close();

/* protocol.c */
int libgpm_proto_close_window();
int libgpm_proto_get_window_attributes(int *w, int *h);
int libgpm_proto_flush_window();
int libgpm_proto_clear_window();
int libgpm_proto_resize_window(int p, int o, double w, double h);
int libgpm_proto_set_color(int color, int rainbow);
int libgpm_proto_set_gradation(int col, int n, double level);
int libgpm_proto_set_dash_width_dmode(int itype, int isize, int imode);
int libgpm_proto_draw_points(gpm_xpoint_t *ps, int npts);
int libgpm_proto_draw_lines(gpm_xpoint_t *ps, int npts);
int libgpm_proto_draw_rectangle(int xs, int ys, int xe, int ye);
int libgpm_proto_fill_rectangle(int xs, int ys, int xe, int ye);
int libgpm_proto_fill_polygon(gpm_xpoint_t *ps, int npts);
int libgpm_proto_draw_arc(int x, int y, unsigned int width, int height, 
                          int angle1, int angle2);
int libgpm_proto_fill_arc(int x, int y, unsigned int width, int height, 
                          int angle1, int angle2);

#ifdef __cplusplus
}
#endif

#endif /* _LIBGPM_PRIVATE_H_ */
