/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: proc-win32.c,v 1.3 2005/10/30 09:55:30 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WIN32
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif
#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif
#ifdef HAVE_SYS_RESOURCE_H
# include <sys/resource.h>
#endif

#include "libgpm.h"
#include "libgpmpriv.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32

int libgpm_process_control_init(gpm_child_controller_t *childcntl){
  SECURITY_ATTRIBUTES secAttr;
  secAttr.nLength = sizeof(SECURITY_ATTRIBUTES);
  secAttr.lpSecurityDescriptor = NULL;
  secAttr.bInheritHandle = TRUE;
  /* initialize */
  childcntl->pifd[0] = INVALID_HANDLE_VALUE;
  childcntl->pifd[1] = INVALID_HANDLE_VALUE;
  childcntl->pofd[0] = INVALID_HANDLE_VALUE;
  childcntl->pofd[1] = INVALID_HANDLE_VALUE;
  childcntl->pid = -1;
  childcntl->hProc = INVALID_HANDLE_VALUE;
  /* stop signal */
  childcntl->sig_int  = signal(SIGINT,  SIG_IGN);
  childcntl->sig_term = signal(SIGTERM, SIG_IGN);
  /* create comunication pipes */
  if(CreatePipe(&childcntl->pifd[0], &childcntl->pifd[1], 
                &secAttr, 0) == FALSE)
    return -1;
  if(CreatePipe(&childcntl->pofd[0], &childcntl->pofd[1], 
                &secAttr, 0) == FALSE)
    return -1;
  return 0;
}

int libgpm_process_control_clean(gpm_child_controller_t *childcntl){
  if(childcntl->hProc != INVALID_HANDLE_VALUE)
    WaitForInputIdle(childcntl->hProc, 5000);
  /* close pipe */
  if(childcntl->pifd[0] != INVALID_HANDLE_VALUE)
    CloseHandle(childcntl->pifd[0]);
  if(childcntl->pifd[1] != INVALID_HANDLE_VALUE)
    CloseHandle(childcntl->pifd[1]);
  if(childcntl->pofd[0] != INVALID_HANDLE_VALUE)
    CloseHandle(childcntl->pofd[0]);
  if(childcntl->pofd[1] != INVALID_HANDLE_VALUE)
    CloseHandle(childcntl->pofd[1]);
  if(childcntl->pid != -1)
    childcntl->pid = -1;
  /* start signal */
  signal(SIGINT,  childcntl->sig_int);
  signal(SIGTERM, childcntl->sig_term);
  return 0;
}

int libgpm_process_create(const char *bin, gpm_child_controller_t *childcntl){
  BOOL success;
  STARTUPINFO si;
  PROCESS_INFORMATION pi;
  HANDLE hProc;
  HANDLE hPpo, hPpi;
  char tmp[_MAX_PATH];
  strncpy(tmp, bin, _MAX_PATH); /* for CreateProcessW() */
  ZeroMemory(&si,sizeof(si));
  si.cb = sizeof(STARTUPINFO);
  si.dwFlags = STARTF_USESTDHANDLES;
  si.hStdInput  = childcntl->pofd[0];
  si.hStdOutput = childcntl->pifd[1];
  si.hStdError  = INVALID_HANDLE_VALUE;
  hProc = GetCurrentProcess();
  if(DuplicateHandle(hProc, childcntl->pifd[0], hProc, &hPpi, 
                     0, FALSE, DUPLICATE_SAME_ACCESS) == FALSE){
     return -1;
  }
  if(DuplicateHandle(hProc, childcntl->pofd[1], hProc, &hPpo, 
                     0, FALSE, DUPLICATE_SAME_ACCESS) == FALSE){
     CloseHandle(hPpi);
     return -1;
   }
  CloseHandle(childcntl->pifd[0]);
  CloseHandle(childcntl->pofd[1]);
  childcntl->pifd[0] = hPpi;
  childcntl->pofd[1] = hPpo;
  success = CreateProcess(NULL, tmp, NULL, NULL, TRUE, NORMAL_PRIORITY_CLASS,
                          NULL, NULL, &si, &pi);
  CloseHandle(childcntl->pifd[1]);
  CloseHandle(childcntl->pofd[0]);
  childcntl->pifd[1] = INVALID_HANDLE_VALUE;
  childcntl->pofd[0] = INVALID_HANDLE_VALUE;
  if(success == FALSE)
    return -1;
  childcntl->hProc = pi.hProcess;
  CloseHandle(pi.hThread);
  childcntl->pid = pi.dwProcessId;
  return 0;
}

int libgpm_process_wait(int pid, int *status){
  int ret;
  DWORD st;
  HANDLE h;
  h = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pid);
  if(h == NULL){ return -1; }
  WaitForSingleObject(h, INFINITE);
  GetExitCodeProcess(h, &st);
  CloseHandle(h);
  ret = 0;
  if(status)
    *status = (int)st;
  /* if child process is console application and it was force
     terminated by the signal (^C) then exit code will be set
     to number 3. */
  if(st == 3){  ret = 1; }
  return ret;
}
#endif

#ifdef __cplusplus
}
#endif
