/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: protocol.c,v 1.6 2005/10/30 09:55:30 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WIN32
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <math.h>

#include "libgpm.h"
#include "libgpmpriv.h"

#ifdef __cplusplus
extern "C" {
#endif


/* call drawing methods */
int libgpm_proto_close_window(){
  static const int c = GPM_PROTO_CLOSE_WINDOW;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  return 0;
}

int libgpm_proto_get_window_attributes(int *w, int *h){
  static const int c = GPM_PROTO_GET_WINDOW_ATTRIBUTES;
  if(libgpm_comm_send_int(c) != 0)   return -1;
  if(libgpm_comm_recive_int(w) != 0) return -1;
  if(libgpm_comm_recive_int(h) != 0) return -1;
  return 0;
}

int libgpm_proto_flush_window(){
  static const int c = GPM_PROTO_FLUSH_WINDOW;
  int code;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_recive_int(&code);
  return 0;
}

int libgpm_proto_clear_window(){
  static const int c = GPM_PROTO_CLEAR_WINDOW;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  return 0;
}

int libgpm_proto_resize_window(int p, int o, double w, double h){
  static const int c = GPM_PROTO_RESIZE_WINDOW;
  int code;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  if(libgpm_comm_send_int(p) != 0) return -1;
  if(libgpm_comm_send_int(o) != 0) return -1;
  if(libgpm_comm_send_float(w) != 0) return -1;
  if(libgpm_comm_send_float(h) != 0) return -1;
  libgpm_comm_recive_int(&code);
  return 0;
}

int libgpm_proto_set_color(int color, int rainbow){
  static const int c = GPM_PROTO_SET_COLOR;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(color);
  libgpm_comm_send_int(rainbow);
  return 0;
}

int libgpm_proto_set_gradation(int col, int n, double level){
  static const int c = GPM_PROTO_SET_GRADATION;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(col);
  libgpm_comm_send_int(n);
  libgpm_comm_send_float(level);
  return 0;
}

int libgpm_proto_set_dash_width_dmode(int itype, int isize, int imode){
  static const int c = GPM_PROTO_SET_DASH_WIDTH_DMODE;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(itype);
  libgpm_comm_send_int(isize);
  libgpm_comm_send_int(imode);
  return 0;
}

int libgpm_proto_draw_points(gpm_xpoint_t *ps, int npts){
  static const int c = GPM_PROTO_DRAW_POINTS;
  int x, y, i;
  if(npts > 0){
    if(libgpm_comm_send_int(c) != 0)
      return -1;
    libgpm_comm_send_int(npts);
    for(i=0; i<npts; i++){
      x = ps[i].x; y = ps[i].y;
      libgpm_comm_send_int(x);
      libgpm_comm_send_int(y);
    }
  }
  return 0;
}

int libgpm_proto_draw_lines(gpm_xpoint_t *ps, int npts){
  static const int c = GPM_PROTO_DRAW_LINES;
  int x, y, i;
  if(npts > 0){
    if(libgpm_comm_send_int(c) != 0)
      return -1;
    libgpm_comm_send_int(npts);
    for(i=0; i<npts; i++){
      x = ps[i].x; y = ps[i].y;
      libgpm_comm_send_int(x);
      libgpm_comm_send_int(y);
    }
  }
  return 0;
}

int libgpm_proto_draw_rectangle(int xs, int ys, int xe, int ye){
  static const int c = GPM_PROTO_DRAW_RECTANGLE;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(xs);
  libgpm_comm_send_int(ys);
  libgpm_comm_send_int(xe);
  libgpm_comm_send_int(ye);
  return 0;
}

int libgpm_proto_fill_rectangle(int xs, int ys, int xe, int ye){
  static const int c = GPM_PROTO_FILL_RECTANGLE;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(xs);
  libgpm_comm_send_int(ys);
  libgpm_comm_send_int(xe);
  libgpm_comm_send_int(ye);
  return 0;
}

int libgpm_proto_fill_polygon(gpm_xpoint_t *ps, int npts){
  static const int c = GPM_PROTO_FILL_POLYGON;
  int x, y, i;
  if(npts > 0){
    if(libgpm_comm_send_int(c) != 0)
      return -1;
    libgpm_comm_send_int(npts);
    for(i=0; i<npts; i++){
      x = ps[i].x; y = ps[i].y;
      libgpm_comm_send_int(x);
      libgpm_comm_send_int(y);
    }
  }
  return 0;
}

int libgpm_proto_draw_arc(int x, int y, unsigned int width, int height, 
                          int angle1, int angle2){
  static const int c = GPM_PROTO_DRAW_ARC;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(x);
  libgpm_comm_send_int(y);
  libgpm_comm_send_int((int)width);
  libgpm_comm_send_int((int)height);
  libgpm_comm_send_int(angle1);
  libgpm_comm_send_int(angle2);
  return 0;
}

int libgpm_proto_fill_arc(int x, int y, unsigned int width, int height, 
                          int angle1, int angle2){
  static const int c = GPM_PROTO_FILL_ARC;
  if(libgpm_comm_send_int(c) != 0)
    return -1;
  libgpm_comm_send_int(x);
  libgpm_comm_send_int(y);
  libgpm_comm_send_int((int)width);
  libgpm_comm_send_int((int)height);
  libgpm_comm_send_int(angle1);
  libgpm_comm_send_int(angle2);
  return 0;
}

#ifdef __cplusplus
}
#endif
