/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: pstray.h,v 1.2 2005/10/30 09:55:30 orrisroot Exp $ */

#ifndef  LIBGPM_PSTRAY_H
# define LIBGPM_PSTRAY_H

#ifdef LIBGPM_PSFUNC_C_SOURCE

#ifdef __cplusplus
extern "C" {
#endif

static const char *gpmps_tray_data[] = {
  "%% Tray Select Definition",
  "%% File: TrayPs",
  "  ",
  "/inch { 72 mul } bind def",
  "/largepaperarray [ /b4 /a4 ] def",
  "/setpaper {",
  "  dup where papertray and {",
  "  exch get exec ",
  "  } if",
  "} bind def",
  "/trayarray [ /b4tray /a4tray ] def",
  "/settray {",
  "  dup statusdict exch known {",
  "  {",
  "    statusdict begin load exec end",
  "  } stopped {",
  "    $error /newerror get {",
  "      $error /errorname get /rangecheck eq {",
  "        (Tray not found, using default tray.) print flush",
  "        /papertray false def",
  "      }{",
  "        handleerror",
  "      } ifelse",
  "        $error /newerror false put",
  "      } if",
  "    } if",
  "  }{",
  "    pop",
  "  } ifelse",
  "} bind def",
  "  ",
  "/papertray true def",
  "/widtharray  [ 9.84 inch 8.27 inch ] def",
  "/heightarray [ 13.9 inch 11.69 inch ] def",
  "/xoffset 0 def",
  "/yoffset 0 def",
  "/landscape false def",
  "/pagesetup {",
  "  dup widtharray exch get /paperwidth exch def",
  "  dup heightarray exch get /paperheight exch def",
  "  dup trayarray exch get settray",
  "  largepaperarray",
  "  exch get setpaper",
  "} bind def",
  "/@b4 {0 pagesetup} def",
  "/@a4 {1 pagesetup} def",
  "/@manualfeed {",
  "/manualfeed true def",
  "statusdict /manualfeed known {",
  "statusdict /manualfeed true put",
  "statusdict /manualfeedtimeout 120 put",
  "} if } bind def",
  "/@landscape {/landscape true def} bind def",
  "  ",
  "%% End of TrayPS",
  NULL};

#ifdef __cplusplus
}
#endif

#endif /* LIBGPM_PSFUNC_C_SOURCE */

#endif /* LIBGPM_PSTRAY_H */
