/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: argen.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/******************************************
*           Generate AR signal            *
*-----------------------------------------*
*   MODE                                  *
*      M : put parameter to buffer        *
*      E : get parameter from buffer      *
*   PARAMETER BUFFER                      *
*   OUTPUT DATA POINT                     *
*-----------------------------------------*
* first version (on PC)                   *
*   28th Oct 1988 produced by M.Akima     *
* buffer version (on WS but Non Array)    *
*   16th Mar 1991 modified by K.Hagiwara  *
* satellite version                       *
*   15th Apr 1993 modified by K.Takebe    *
*    6th Mar 1995 modified by N.Hayashi   *
******************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <math.h>
#include <ctype.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "rand_sub.h"

#ifdef __cplusplus
extern "C" {
#endif

/* struct offset for param buffer */
#define STRUCT_OFFSET  4


typedef	struct	ardat {
	long	init_val ;
	long	loop_iteration ;
	long	AR_order ;
	double	AR_param[100];
        double  variance;
	char	reserve[92];
}	ARDAT ;


/* prototype */
int    struct_to_buff   (double *p_data, ARDAT *ARdat);
void   buff_to_struct   (double *p_data, int length,
				     ARDAT *ARdat);
int    Gen_ARdat        (ARDAT *ARdat, double *work, int dpt);
void   get_AR_parameter (ARDAT *ARdat);


DLLEXPORT int mod_ispp_argen(){
  ARDAT  ARdat;
  int    pdpt, dpt;
  int    dim, index[MAX_INDEX], pdim, pindex[MAX_INDEX];
  double *work, *pwork;
  
  if ( GetScalar( 0 ) > 0 ) {
    /* LOAD PARAMETER FROM BUFFER AND GENERATE AR SIGNAL */ 
    if (( pwork = GetSeries( 0, &pdim, pindex ) ) == NULL )
      return (21);
    dpt   = (int)GetScalar( 1 );
    pdpt  = IndexSize( pdim, pindex );

    if ( dpt <= 0 || pdpt <= 0 )
      return (20);

    if (( work = AllocBuffer(dpt) ) == NULL )
      return (8);

    buff_to_struct( pwork, pindex[0] , &ARdat );
    Gen_ARdat( &ARdat , work , dpt );
    dim = 1;
    index[0] = dpt;
    ReturnSeries( work, dim, index );
    FreeBuffer( work );
  } else {
    /* PUT PARAMETER TO BUFFER */
    get_AR_parameter(&ARdat);
    if ( ARdat.AR_order > 0 ) {
      pdpt = (int)ARdat.AR_order + STRUCT_OFFSET;
      if (( pwork = AllocBuffer( pdpt ) ) == NULL )
	return (8);
      struct_to_buff( pwork , &ARdat );
      pdim = 1;
      pindex[0] = pdpt;
      ReturnSeries( pwork , pdim, pindex );
    } else 
      return (22);
	FreeBuffer( pwork );
  }
  return 0;
}

/***********************************
*   GET AR PARAMETER FROM CONSOLE  *
***********************************/
void get_AR_parameter(ARDAT *ARdat ){
  char pc[20];
  long int i ;
	
 /* SET Initinal Value */
  do {
    printf(" Init : ");
    scanf( "%s", pc );
    rewind(stdin);
  } while ( isalpha((int) pc[0] ) ==  1 );
  ARdat->init_val = atol(pc);
  
 /* SET Loop */
  do {
    printf(" Ignored Iteration : ");
    scanf( "%s", pc );
    rewind(stdin);
  } while ( isalpha((int) pc[0] ) == 1 );
  ARdat->loop_iteration = atol(pc);
  
 /* SET Order */
  do {
    printf(" Order of AR : ");
    scanf( "%s", pc );
    rewind(stdin);
  } while ( isalpha((int) pc[0] ) == 1 );
  ARdat->AR_order = atol(pc);
  
  /* SET Parameter */
  for( i = 0; i < ARdat->AR_order; i++ ){
    do {
      printf(" AR Coef[%2ld] : ",i+1 );
      scanf( "%s", pc );
      rewind(stdin);
    } while ( isalpha((int) pc[0] ) == 1 );
    ARdat->AR_param[ i ] = atof(pc);
#ifdef _DEBUG_ISPP
printf("ARdat->AR_param[%d]:%g\n",i,ARdat->AR_param[i]);
#endif
  }

 /* SET Input Variance */
  do{
    printf(" Input Variance : ");
    scanf("%s",pc);
    rewind(stdin);
  }while( isalpha((int) pc[0] ) == 1);
  ARdat->variance = atof(pc);
#ifdef _DEBUG_ISPP
printf("Input Variance:%g\n",ARdat->variance);
#endif
  /* End of get_AR_parameter() */
}


/* Generate AR process */
int Gen_ARdat(ARDAT *ARdat ,double *work ,int dpt ){
  int    M[521], JJ = 0;
  int    i , j;
  double x[31];
  int    IOJ ;

/*  int    seed ; */
/*  seed = (int)ARdat->init_val ; */
/*  Gen_M_series( seed , M ); */

  for ( i = 0; i < 521; i++ ) /* by take, initialization */
    M[i] = 0;

  Gen_M_series(ARdat->init_val , M );

#ifdef _DEBUG_ISPP
  for(i=0;i<521;i++) printf(" data :%10d \n",M[i]);
#endif
  for(i=0;i<=ARdat->AR_order;i++)
    x[i] = 0.0 ;
  
  for(i=1;i<=ARdat->loop_iteration+1;i++ ){
    for(j=1;j<=ARdat->AR_order;j++)
      x[j-1] = x[j];
    x[ ARdat->AR_order ] =
      rnd_nor( i-1 , 0.0 , ARdat->variance, M  ,&JJ );
    
    for(j=1;j<=ARdat->AR_order;j++){
      IOJ = (int)ARdat->AR_order+1-j ;
      x[ARdat->AR_order] -= ( ARdat->AR_param[j-1]*x[IOJ-1] );
    }
  }
  
  for(i=1;i<=dpt;i++ ){
    for(j=1;j<=ARdat->AR_order;j++) x[j-1] = x[j];
    
    x[ ARdat->AR_order ] =
      rnd_nor( i-1 , 0.0 ,ARdat->variance, M  ,&JJ );
    
    for(j=1;j<=ARdat->AR_order;j++){
      IOJ = (int)ARdat->AR_order+1-j ;
      x[ARdat->AR_order] -= (ARdat->AR_param[j-1]*x[IOJ-1]);
    }
    
    work[ i-1 ] = x[ ARdat->AR_order ];
    
#ifdef _DEBUG_ISPP
    printf("PASS2 data %d = %g \n",i,work[i]);
#endif
  }
  return 0;
}


void buff_to_struct(double *p_data,int length,ARDAT *ARdat){
  int	i;
  
  ARdat->init_val       = (long)p_data[0];
  ARdat->loop_iteration = (long)p_data[1];
  ARdat->AR_order       = (long)p_data[2];
  for( i=0 ; i<(int)(ARdat->AR_order) ; i++)
    ARdat->AR_param[i] = p_data[i+3];
  if((int)(ARdat->AR_order)+3 == length)
    ARdat->variance = 1.0;
  else {
    if(p_data[length-1] <= 0.0)
      ARdat->variance = 1.0;
    else
      ARdat->variance = p_data[length-1];
  }
  /* End of buff_to_struct() */
}

/*     SET ARdat TO BUFFER     */
int struct_to_buff(double *p_data,ARDAT *ARdat){
  int	i;
  int	ret;
  
  p_data[0] = (double)ARdat->init_val;
  p_data[1] = (double)ARdat->loop_iteration;
  p_data[2] = (double)ARdat->AR_order;
  for( i=0 ; i<(int)(ARdat->AR_order) ; i++)
    p_data[i+3] = ARdat->AR_param[i];
  ret = (int)(ARdat->AR_order + STRUCT_OFFSET);
  p_data[ret -1] = ARdat->variance;
  return(ret);
  /* End of struct_to_buff() */
}


/* ----------------------------------- *
  generate random series. See nrand.c
* ------------------------------------ */


#ifdef __cplusplus
}
#endif
