/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: butwmake.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LOWPASS  1
#define HIGHPASS 2
#define BANDPASS 3

int ispp_butwmake_highpass();  /* referred to hpbtw.c */
int ispp_butwmake_lowpass();   /* refereed to lpbtw.c */
int ispp_butwmake_bandpass();  /* refereed to bpbtw.c */

DLLEXPORT int mod_ispp_butwmake(){
  int argc, ret;
  int method;

  /* check number of arguments */
  argc = GetArgNum();
  if(argc != 7)
    return 2; /* illegal parameter */

  /* check using method */
  if(strcmp(GetArgType(0),"scalar") != 0)
    return 2; /* illegal parameter */
  method = (int)GetScalar(0);
  switch(method){
  case LOWPASS:  ret = ispp_butwmake_lowpass(); break;
  case HIGHPASS: ret = ispp_butwmake_highpass(); break;
  case BANDPASS: ret = ispp_butwmake_bandpass(); break;
  default: ret = 2; break;
  }
  return ret;
}

#ifdef __cplusplus
}
#endif
