/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: complex.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <math.h>
#include "Complex.h"

#ifdef __cplusplus
extern "C" {
#endif

ComplexValue cplx(double i,double j ){
  ComplexValue k;
  k.real = i;
  k.imag = j;
  return( k );
}

ComplexValue cadd(ComplexValue i,ComplexValue j ){

  ComplexValue k;
  
  k.real = i.real + j.real;
  k.imag = i.imag + j.imag;
  
  return( k );
}

ComplexValue cinv(ComplexValue i ){
  ComplexValue k;
  
  k.real = -i.real;
  k.imag = -i.imag;
  
  return( k );
}

ComplexValue csub(ComplexValue i,ComplexValue j ){
  ComplexValue k;
  
  k.real = i.real - j.real;
  k.imag = i.imag - j.imag;
  
  return( k );
}

ComplexValue cmpl(ComplexValue i,ComplexValue j ){
  ComplexValue k;
  
  k.real = i.real*j.real - i.imag*j.imag;
  k.imag = i.real*j.imag + i.imag*j.real;
  
  return( k );
}

ComplexValue cdiv(ComplexValue i,ComplexValue j ){
  ComplexValue k;
  double dd;
  
  dd = j.real*j.real + j.imag*j.imag;
  
  k.real = (i.real*j.real + i.imag*j.imag)/dd;
  k.imag = (i.imag*j.real - i.real*j.imag)/dd;
  
  return ( k );
}

ComplexValue cplxsqrt(ComplexValue a ){
  ComplexValue b;
  double amp,phase;
  
  amp = sqrt( a.real*a.real + a.imag*a.imag );
  phase = atan( a.imag/a.real )/2.0;
  
  b.real = amp * cos( phase );
  b.imag = amp * sin( phase );
  
  return ( b );
}

#ifdef __cplusplus
}
#endif
