/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: dccut.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/****************************
*        DC CUT             *
****************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_dccut(){
  register int   i;
  int            length, dim, index[MAX_INDEX];
  Buffer        *data;
  double         ave;
  
  /***** Load System Parameter *****/
  data = GetSeries(0, &dim, index);
  if(data == NULL) return (17);
  
  /***** DC Cut *****/
  length = IndexSize(dim, index);
  
  ave = 0.0;
  for (i = 0; i < length; i++)  {
    ave += data[i];
  }
  ave /= (double) length;
  
  for (i = 0; i < length; i++) {
    data[i] = data[i] - ave;
  }
  
  /***** Store System Parameter *****/
  ReturnSeries(data, dim, index);
  FreeBuffer(data);
  return 0;
}
#ifdef __cplusplus
}
#endif
