#
# ispp2.sl
# filter processing
#
sampling(512);
series zr,zi,pr,pi;
series a,b;
series u,v;
delay=50;
datp=511;
impulse=(1,(1~datp)*0);
d_impulse=((0~delay)*0,impulse);
wopen(1,"A4",0,0);
color("red","black");
x=0~205;
origin(20,40);
size(80,50);
scale("N","F","N","A",0,205);
graph(impulse,x,0,0,0,0,0);
title(1,"Data Point","Amplitude");
axis(1,1,"XY","XY",6,0,1,50,0.5,0);
frame();
origin(120,40);
graph(d_impulse,x,0,0,0,0,0);
title(1,"Data Point","Amplitude");
axis(1,1,"XY","XY",6,0,1,50,0.5,0);
frame();

# filter design
gain=butwmake(1,100,13,zr,zi,pr,pi);
iirmake(zr,zi,pr,pi,a,b);
firtemp=fir(b,d_impulse);
firinp=cut(firtemp,delay+1,datp+delay+1);
origin(20,110);
size(80,50);
scale("N","F","N","A",0,205);
graph(firtemp,x,0,0,0,0,0);
title(1,"Data Point","Amplitude");
axis(1,1,"XY","XY",6,0,1,50,900,0);
frame();
origin(120,110);
graph(firinp,x,0,0,0,0,0);
title(1,"Data Point","Amplitude");
axis(1,1,"XY","XY",6,0,1,50,900,0);
frame();

# impulse response
output=iir(a,firinp)*gain;
origin(20,180);
x=0~160;
size(120,40);
scale("N","F","N","A",0,160);
graph(output,x,0,0,0,0,0);
title(1,"Data Point","Amplitude");
axis(1,1,"XY","XY",6,0,1,20,0.3,0);
frame();

# power spectrum
spcf(output,u,v);
origin(20,230);
size(120,40);
scale("N","A","N","A");
graph(u,"F",0,0,0,0,0);
title(1,"Frequency","Power");
axis(1,1,"XY","XY",6,0,1,50,0.000004,0);
#axis(1,1,"XY","XY",6,0,0,0,0,0);
frame();