/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: fftc.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"


/******************************************************
 *    COMPLEX FFT PROGRAM                             *
 *----------------------------------------------------*
 *    FFTC  [ P , I ] IB1 , IB2 , IB3 , IB4           *
 *            IB1 : REAL ( INPUT )                    *
 *            IB3 : REAL      ( OUTPUT )              *
 *            IB4 : IMAGINARY ( OUTPUT )              *
 *----------------------------------------------------*
 *                 1986 , 6 , 24                      *
 *               C  Version  7/5/89                   *
 *         SATELLITE Version April 19th, 1993         *
 *****************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern int  fft1 (double *ar, double *ai, int n, int flag);

DLLEXPORT int mod_ispp_fftc(){
  Buffer *xr, *xi;
  int    nn, nm;
  int    ifg, i;
  int    n;
  char   *pc;
  int    o1, o2;
  int    dim1, dim2, index1[MAX_INDEX], index2[MAX_INDEX];
  
  pc = GetString( 0 );
  xr = GetSeries( 1, &dim1, index1 );
  xi = GetSeries( 2, &dim2, index2 );
  o1 = GetBufferID(3);
  o2 = GetBufferID(4);

  switch (pc[0]) {
  case 'P':
    ifg = 0;
    break;
  case 'I':
    ifg = -1;
    break;
  default:
    printf(">>>> Illigal mode <<<<<<<\n");
    return (-1);
  }
  
  if ( xr == NULL || xi == NULL )
    return (4);
  nn = index1[0];
  nm = index2[0];
  if ( dim1 != 1 || dim2 != 1 || o1 <= 0 || o2 <= 0 )
    return (17);
  
  if (nn != nm)
    return (18);
  
  n = 1;
  for (i = 1; i <= 20; i++) {
    n *= 2;
    if (n == nn)
      break;
  }
  
  if (i >= 20)
    return (18);

  /***** FFT *****/
  fft1(xr, xi, nn, ifg);
  
  if ( WriteBuffer( o1, dim1, index1, xr ) == -1 ) return (3);
  if ( WriteBuffer( o2, dim2, index2, xi ) == -1 ) return (3);
  
  return 0;
}

#ifdef __cplusplus
}
#endif
