/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: hil.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/********************************************
 *    HILBERT TRANSFORM PROGRAM             *
 *------------------------------------------*
 *    HIL IB1 , IB2 , IB3                   *
 *        IB1 : REAL      ( INPUT  )        *
 *        IB2 : REAL      ( OUTPUT )        *
 *        IB3 : IMAGINARY ( OUTPUT )        *
 *------------------------------------------*
 *                    1986 , 11 , 6         *
 *                    1989 ,  7 , 28        *
 *******************************************/
#ifdef __cplusplus
extern "C" {
#endif

extern int  fft1 (double *ar, double *ai, int n, int flag );

DLLEXPORT int mod_ispp_hil(){
  Buffer *xr, *xi, *xxr, *xxi, *max;
  int    o1, o2, dim, idx[MAX_INDEX];
  int    i, n, n1, nn, nn1;
  
  xr = GetSeries( 0, &dim, idx );
  n1 = IndexSize( dim, idx );
  n = 1;
  for ( i = 0; i < 12; i ++ ) {
    n *= 2;
    if ( n == n1 ) break;
  }
  if ( n != n1 )
    return (18);
  if (( xi = AllocBuffer( n1 ) ) == NULL )
    return (4);
  o1 = GetBufferID(1);
  o2 = GetBufferID(2);
  if ( o1 <= 0 || o2 <= 0 )
    return (3);

  nn = n1;
  max = xi + nn;
  for ( xxi = xi; xxi < max; xxi++ )
    (*xxi) = 0.0;
  
  /***** FFT *****/
  fft1( xr, xi, nn, 0 );
  
  nn1 = nn/2;
  for ( xxr = xr+nn1, xxi = xi+nn1; xxr < max; xxr++, xxi++ ) {
    (*xxr) = 0.0;
    (*xxi) = 0.0;
  }
  max = xi+nn1;
  for ( xxr = xr, xxi = xi; xxi < max; xxr++, xxi++ ) {
    (*xxr) *= 2.0;
    (*xxi) *= 2.0;
  }
  
  /***** Inv FFT *****/
  fft1( xr, xi, nn, -1 );
  
  if ( WriteBuffer( o1, dim, idx, xr ) == -1 ) return (3);
  if ( WriteBuffer( o2, dim, idx, xi ) == -1 ) return (3);

  FreeBuffer( xr );
  FreeBuffer( xi );
 
  return 0;
}

#ifdef __cplusplus
}
#endif
