/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: hpbtw.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
/*****************************************************************
  (HIGH-PASS)
  Хɣɣҥϥѥե륿߷
  ʼη׻ϤʤϤ롥
  
  HPBTW fc,n,b1,b2,b3,b4,b5
  fc......åȥռȿȿˡ
  n.......ե륿
  b1......¿
  b2......
  b3......˼¿
  b4......˵
  
  '92/3/25
  Żҡʳ
  '92/6/21
  TODA @MCT
  **************************************************************** */
#define PAI 	3.14159265358979323846
#define MAXORD	101

#ifdef __cplusplus
extern "C" {
#endif

static void  btwlp ( int n, double fc, double *are, double *aim, int *oinc,
		     double *gain );

int ispp_butwmake_highpass(){
  double  fc,fs, gain ;
  int	  i,j, n, oinc;
  double  are[MAXORD],aim[MAXORD];
  double  work[MAXORD];

  int     dim;
  int     b1,b2,b3,b4;
  /*((((((((((((((((((((((ǡɤ߹ߡ))))))))))))))))))))))) */
  
  fs= get_sampling();
  
  fc = GetScalar(1);
  n  = (int)GetScalar(2);
  b1 = GetBufferID(3);
  b2 = GetBufferID(4);
  b3 = GetBufferID(5);
  b4 = GetBufferID(6);
  
  if ( b1 == 0 || b2 == 0 || b3 == 0 || b4 == 0 )
    return (3);
  
  if ( n > MAXORD ){
    printf("Filter Order is Too Large!\n");
    return (2);
  }
  
  if (fc<=0){
    printf("Illegal Cut-Off Frequency\n");
    return (2);
  }
  if (n<=0)
    return (2);
  
  /* (((((((((((((((((((((((    η׻))))))))))))))))))))))))  */
  
  fc=2.0*fc/fs;
  
  btwlp( n, fc, are, aim, &oinc, &gain );
  /* printf("oinc%d\n", oinc); */
  
  /* (((((((((((((((((((((((    񤭹    )))))))))))))))))))))))))))) */
  /* ...................			 */
  for ( i = 0 ; i < n ; i++ ){
    work[i] = 1.0 ;
  }
  
  dim=1;
  
  WriteBuffer(b1,dim,&n,work);
  for ( i = 0 ; i < n ; i++ ){
    work[i] = 0.0 ;
  }
  WriteBuffer(b2,dim,&n,work);
  /* ...................				 */
  if ( oinc == n/2 )
    for ( i = n/2, j = 0; i < n; i++, j++ ){
      are[i] =  are[j];
      aim[i] = -aim[j];
    }
  else
    for ( i = n/2 + 1, j = 1; i < n; i++, j++){
      are[i] =  are[j];
      aim[i] = -aim[j];
    } 
  WriteBuffer(b3,dim,&n,are);
  WriteBuffer(b4,dim,&n,aim);
  /* ...................gain			 */
  ReturnScalar(gain);
  
  return 0;
}
/* ********************************************************************
  
  ˤΰַ׻
  
  :
  n.............ե륿
  fc............åȥռȿ
  ϡ
  are...........ˤμ¿ɸ
  aim...........ˤεɸ
  oinc..........ɽˤο
  gain..........ե륿
  ********************************************************************* */
static void btwlp(int n,double fc,double *are,double *aim,int *oinc,
		  double *gain ){
  double  a, tsa, tsb, tsg, tzb, tzc;
  int	i, cas, im;
  /* 
     ................Ϣ³ȿؤѴʥץס
      */
  fc = 4.0*tan(0.5*PAI*fc);
  /* 		printf("fc=%f\n",fc); */
  /* 
     .................ãؿη׻
      */
  cas = n%2;
  cas++;
  switch(cas){
    /* 
       ...................
        */
  case 1:
    /* 						 */
    *oinc = 0 ;
    *gain = 1.0 ;
    for( i=1 ; i<=(n-1) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n)));
      tsa = a*fc;
      tsb = fc*fc;
      tsg = 1.0/(16.0+4.0*tsa+tsb);
      tzb = 2.0*tsg*(tsb-16.0);
      tzc = tsg*(16.0-tsa*4.0+tsb);
      /* 						     */
      *gain *= tsg*16.0;
      /* 						     */
      if( tzb*tzb-4.0*tzc < 0.0 ) im = 1;
      else 	    im = 2;
      switch (im ){
	/* 
	   ....................
	    */
      case 1:
	are[*oinc] = -tzb/2.0;
	aim[*oinc] = sqrt(4.0*tzc-tzb*tzb)/2.0;
	*oinc += 1;
	break;
	/* 
	   ....................º
	    */
      case 2:
	are[*oinc] = (-tzb  +sqrt(tzb*tzb-4.0*tzc)) /2.0;
	are[*oinc+1] = (-tzb -sqrt(tzb*tzb-4.0*tzc)) /2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
    /* 
       .....................
        */
  case 2:
    /* 						 */
    *oinc = 0;
    *gain = 1;
    /* 
       ..................
        */
    tsa = fc;
    *gain = *gain*4.0/(tsa+4.0);
    are[*oinc] = -(tsa-4.0)/(tsa+4.0);
    aim[*oinc] = 0.0;
    (*oinc)++;
    /* 
       ..................N
        */
    for( i=1 ; i<=(n-2) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n)));
      tsa = a*fc;
      tsb = fc*fc;
      tsg = 1.0/(16.0+4.0*tsa+tsb);
      tzb = 2.0*tsg*(tsb-16.0);
      tzc = tsg*(16.0-tsa*4.0+tsb);
      /* 						     */
      *gain *= tsg*16.0;
      /* 						     */
      if( tzb*tzb-4.0*tzc < 0.0 )
	im = 1;
      else
	im = 2;
      switch (im ){
	/* 
	   ....................
	    */
      case 1:
	are[*oinc] = -tzb/2.0;
	aim[*oinc] = sqrt(4.0*tzc-tzb*tzb) /2.0;
	*oinc += 1;
	break;
	/* 
	   ....................º
	    */
      case 2:
	are[*oinc] = (-tzb +sqrt(tzb*tzb-4.0*tzc)) /2.0;
	are[*oinc+1] = (-tzb -sqrt(tzb*tzb-4.0*tzc))  /2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
  }
}

#ifdef __cplusplus
}
#endif
