/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: icep.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
  
  /*****************************************************
   *      Complex Cepstrum Program                      *
   *        For Complex Cepstrum                        *
   *----------------------------------------------------*
   *      ICEP buf1,buf2,buf3,buf4                      *
   *           buf1 -- input buffer( real )             *
   *           buf2 -- input buffer( imag )             *
   *           buf3 -- output buffer( real )            *
   *           buf4 -- output buffer( imag )            *
   *----------------------------------------------------*
   *         1986 , 7 , 17   1989 , 7 , 28  T.Kobayashi *
   ******************************************************/
#ifdef __cplusplus
extern "C" {
#endif

extern int  fft1  (double *ar, double *ai, int n, int flag );

DLLEXPORT int mod_ispp_icep(){
  Buffer *workr, *worki, *wr, *wi, *max;
  int    i, iofd1, iofd2, nod, n2;
  int    dim, dim2, index[MAX_INDEX], index2[MAX_INDEX];
  Buffer phs0, phs1, amp, phase ;
  
  /***** Load System Parameter *****/
  /***** Initial Set *****/
  
  workr = GetSeries(0, &dim, index );
  worki = GetSeries(1, &dim2, index2 );
  iofd1 = GetBufferID(2);
  iofd2 = GetBufferID(3);

  if ( workr == NULL )
    return (4);
  if ( iofd1 <= 0 || iofd2 <= 0 )
    return (3);

  /***** Buffer -> Work Area *****/

  nod = IndexSize( dim, index );
  if ( worki == NULL ) {
    if (( worki = AllocBuffer( nod ) ) == NULL )
      return (8);
    max = worki+nod;
    for ( wi = worki; wi < max; wi++ )
      (*wi) = 0.0;
  } else
    if ( IndexSize( dim2, index2 ) != nod )
      return (18);
  
  /***** FFT *****/
  fft1( workr, worki, nod, 0 );
  
  /***** Restore Liner Component & Complex Exponential *****/
  
  n2 = nod/2;
  phs0 = worki[0];
  phs1 = worki[n2];

  for ( wr = workr, wi = worki, i = 0; i < nod; wr++, wi++, i++ ) {
    amp = (*wr);
    phase = (*wi);
    phase += ( (double)i * ( phs1-phs0 )/(double)n2 + phs0 ) ;
    (*wr) = exp( amp ) * cos( phase ) ;
    (*wi) = exp( amp ) * sin( phase ) ;
  }
  
  /***** IFFT *****/
  fft1( workr, worki, nod, -1 ) ;
  
  /***** Work Area -> Buffer *****/

  if ( WriteBuffer( iofd1, dim, index, workr ) <= 0 )
    return (3);
  if ( WriteBuffer( iofd2, dim, index, worki ) <= 0 )
    return (3);

  return 0;
}
#ifdef __cplusplus
}
#endif
