/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: iir.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/**********************************************************
 *   Infinite Inpulse Response Fileter                     *
 *           FILTERING SPAN = 25                           *
 *---------------------------------------------------------*
 *       X = IIR( BUF1,BUF2 )                              *
 *            BUF1 : PARAMETER BUFFER                      *
 *            BUF2 : INPUT BUFFER                          *
 *---------------------------------------------------------*
 *                        1986 , 7 , 16                    *
 *       F to C       at  1988 , 8 ,  3 by M.Akima         *
 *   SATELLITE LANGUAGE VERSION                            *
 *       At 29th Dec 1992 modified by S.Hitomi             *
 **********************************************************/
#ifdef __cplusplus
extern "C" {
#endif

static int  iir1(Buffer *filter, int span,Buffer *work, int dpt);

DLLEXPORT int mod_ispp_iir(){
  Buffer         *work, *p_work;
  int             dimp, indexp[MAX_INDEX];
  int             dimx, indexx[MAX_INDEX];
  
  /* Get Arguments from SATELLITE LANGUAGE */
  p_work = (Buffer *)GetSeries(0, &dimp, indexp);
  work   = (Buffer *)GetSeries(1, &dimx, indexx);
  
  if (p_work == NULL || work == NULL) return (4);
  if ( dimp != dimx ) return (16);

  /* LOAD COEF. FROM BUFFER AND EXECUTE FIR     */
  if ( dimp == 1 ) {
    if (iir1(p_work, indexp[0], work, indexx[0]) == -1)
      return (2);
    ReturnSeries(work, dimx, indexx);
  /*
  } else if ( dimp == 2 ) {
    if (iir2(p_work, indexp, work, indexx ) == -1)
      return (2);
    ReturnSeries(work, dimx, indexx);
  */
  } else
    return (24);

  return 0;
}

/* GENETATE DATA WITH SET VALUE     */

static int iir1(Buffer *filter,int  span,Buffer *work,int dpt){
  register int     i, j, k;
  Buffer           sum, v;
  
  for (i = 1; i <= dpt; i++) {
    sum = 0.0;
    for (j = 1; j <= span; j++) {
      k = i - j;
      if (k < 1) break;
      v = 0.0;
      if ( fabs(work[k-1]) > 1.0e-30 )
	v = ( fabs( work[k-1]) > 1.0e15 ) ? 1.0e15 : work[k-1];
      sum += (filter[j-1] * v);
    }
    work[i-1] += sum;
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
