/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: iirmake.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "Complex.h"

#ifdef __cplusplus
extern "C" {
#endif

static void  get_transfar_function (int mm, ComplexValue *work,Buffer *a);
static void  get_func              (ComplexValue *a, int m,
                                    ComplexValue *root );
static void  equmpl                (ComplexValue *a,ComplexValue *b, int *m,
                                    ComplexValue root );
DLLEXPORT int mod_ispp_iirmake(){
  int dimpr, indexpr[MAX_INDEX], dimpi, indexpi[MAX_INDEX];
  int dimzr, indexzr[MAX_INDEX], dimzi, indexzi[MAX_INDEX];
  int mm, n, l, i, a_id, b_id;

  Buffer *pr, *pi, *zr, *zi, *a, *b;
  ComplexValue *work;

  /* get parameter */
  zr   = GetSeries(0,&dimzr,indexzr);
  zi   = GetSeries(1,&dimzi,indexzi);
  pr   = GetSeries(2,&dimpr,indexpr);
  pi   = GetSeries(3,&dimpi,indexpi);
  a_id = GetBufferID(4);
  b_id = GetBufferID(5);

  /* parameter check */
  if ( pr == NULL || pi == NULL || zr == NULL || zi == NULL )
    return (4);
  if ( indexpr[0] != indexpi[0] || indexzr[0] != indexzi[0] )
    return (18);
  if ( a_id == 0 || b_id == 0 )
    return (17);

  mm = IndexSize( dimpr, indexpr );
  n = mm+1;
  l = 2*n-1;
  /* memory allocation */
  a = AllocBuffer(n);
  b = AllocBuffer(l);
  work = (ComplexValue*)emalloc(sizeof(ComplexValue)*n);
  if ( a == NULL || b == NULL || work == NULL )
    return (8);

  /* calculate "a" from pole location */
  for ( i = 0; i < mm; i++ )
    work[i] = cplx( pr[i], pi[i] );
  work[mm] = cplx( 0.0, 0.0 );
  get_transfar_function( mm, work, a );

  /* calculate "b" from pole location */
  for ( i = 0; i < mm; i++ )
    work[i] = cplx( zr[i], zi[i] );
  work[mm] = cplx( 0.0, 0.0 );
  get_transfar_function( mm, work, b );

  /* change coeficient to suitable one */
  for ( i = 0; i < n; i++ )
    a[i] = -a[i+1];
  for ( i = n; i < l; i++ )
    b[i] = 0.0;
  
  dimpr = 1;
  indexpr[0] = mm;
  indexzr[0] = l;
  if ( WriteBuffer( a_id, dimpr, indexpr, a ) == -1 ) return (3);
  if ( WriteBuffer( b_id, dimpr, indexzr, b ) == -1 ) return (3);

  FreeBuffer( pr );
  FreeBuffer( pi );
  FreeBuffer( zr );
  FreeBuffer( zi );
  FreeBuffer( a );
  FreeBuffer( b );
  efree( work );
  return 0;
}

static void get_transfar_function(int mm, ComplexValue *work, Buffer *a ){
  int i;
  ComplexValue *s;

  s = (ComplexValue*)emalloc(sizeof(ComplexValue)*(mm+1));

  for ( i = 0; i <= mm ; i++ )
    s[i] = cplx( 0.0, 0.0 );

  get_func( s, mm, work );
  for ( i = 0; i <= mm; i++ )
    a[i] = s[i].real;
  efree( s );
}

static void get_func( ComplexValue *a,int m, ComplexValue *root){
  int i, n;
  ComplexValue *b;

  b = (ComplexValue*)emalloc(sizeof(ComplexValue)*(m+1));

  n = 0;
  a[0] = cplx( 1.0, 0.0 );

  for ( i = 0; i < m; i++ )
    equmpl( a, b, &n, root[i] );

  efree( b );
}

static void equmpl(ComplexValue *a,ComplexValue *b,int *m,ComplexValue root ){
  ComplexValue c, d;
  int i;

  c = cplx(0.0,0.0);
  d = root;

  for ( i = 0; i <= *m; i++ )
    b[i] = a[i];

  for ( i = 1; i <= *m; i++ )
    a[i] = csub( b[i],  cmpl( d, b[i-1] ) );
  c = cmpl( d , b[*m] );
  (*m)++;
  a[*m] = cinv(c);
}

#ifdef __cplusplus
}
#endif
