/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: mul.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*******************************
* Visual Process Command Lib.  *
*       ( 2-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : mul            *
*    ( Ver 1.0 : 1993/03/10 )  *
*******************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

static void ispp_mul ( Buffer *x, Buffer *y, Buffer *z, int mx, int nx, 
		       int my, int ny );

DLLEXPORT int mod_ispp_mul(){
  Buffer *x, *xx, *y, *yy, *z, *zz, *mm;
  int    index1[MAX_INDEX],index2[MAX_INDEX],index3[MAX_INDEX];
  int    dim, dim2, max_dim, mx, my;
  int    i, ix, iy, k, l, m, n, max, flag;

  if ((x = GetSeries( 0, &dim , index1 )) == NULL ){
    return (4);
  }
  if ((y = GetSeries( 1, &dim2, index2 )) == NULL ){
    return (4);
  }

  if ( dim == 1 ) {
    dim = 2;
    index1[1] = index1[0];
    index1[0] = 1;
  }
  if ( dim2 == 1 ) {
    dim2 = 2;
    index2[1] = index2[0];
    index2[0] = 1;
  }

  if ( dim == dim2 ) {
    for ( i = 0; i < dim-2; i++ )
      index3[i] = index1[i];
    flag = 0;
  } else {
    if ( dim == 2 ) {
      for ( i = 0; i < dim2-2; i++ )
	index3[i] = index2[i];
      flag = 1;
    } else if ( dim2 == 2 ) {
      for ( i = 0; i < dim-2; i++ )
	index3[i] = index1[i];
      flag = 2;
    } else {
      return (7);
    }
  }

  max_dim = ( dim > dim2 ) ? dim : dim2;

  m = index3[max_dim-2] = index1[dim -2];
  k = index1[dim    -1];
  l = index2[dim2   -2];
  n = index3[max_dim-1] = index2[dim2-1];

  if ( k != l ) {
    return (7);
  }

  i   = m*n;
  ix  = k*m;
  iy  = n*l;

  max = IndexSize( max_dim, index3 );
  mx  = IndexSize( dim    , index1 ) / ix;
  my  = IndexSize( dim2   , index2 ) / iy;

  if (( z = AllocBuffer( max ) ) == NULL ){
    return (8);
  }

  mm   = z + max;

  switch ( flag ) {

  case 0:
    if ( mx != my )
      return (7);
    for ( xx = x, yy = y, zz = z; zz < mm; zz+=i, xx += ix, yy+=iy )
      ispp_mul( xx, yy, zz, m, k, l, n );
    break;
  case 1:
    for ( xx = x, yy = y, zz = z; zz < mm; zz+=i, yy+=iy )
      ispp_mul( xx, yy, zz, m, k, l, n );
    break;
  case 2:
    for ( xx = x, yy = y, zz = z; zz < mm; zz+=i, xx+=ix )
      ispp_mul( xx, yy, zz, m, k, l, n );
    break;
  default:
    return (7);
    break;
  }

  ReturnSeries( z, max_dim, index3 );
  FreeBuffer( z );
  FreeBuffer( x );
  FreeBuffer( y );
  return 0;
}

static void ispp_mul(Buffer *x,Buffer *y,Buffer *z,int mx,int nx,
		     int my,int ny ){
  Buffer *zz;
  int    dpt2, dpt3;
  int     i, j, k;

  for ( j = 0; j < mx; j++ ) {
    dpt3 = j*ny;
    dpt2 = j*nx;
    for ( k = 0; k < ny; k++ ) {
      zz = z + dpt3 + k;
      *zz = 0.0;
      for ( i = 0; i < my; i++ )
	*zz += x[ dpt2+i ]*y[ k+i*ny ];
    }
  }
}
#ifdef __cplusplus
}
#endif
