/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nrand.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

#include "rand_sub.h"
/******************************************
      nrand(dpt,init,mean,var);
  
	dpt   : Output data points
	init  : seed
        mean  : mean
	var   : variance
        Date 28th Oct 1988 by M.Akima

       Modified for SATELITE by K.Hagiwara
       Re_Modified by T.Hayasaka
******************************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_nrand(){
  register int    i;
  int      dpt, init;
  double   mean, variance;
  Buffer   *work;
  int      dim = 1, idx[5];
  int      M[521], J;

  dpt      = idx[0] = (int)GetScalar(0);
  init     = (int)GetScalar(1);
  mean     = GetScalar(2);
  variance = GetScalar(3);
  
  if (init == 0)        return (2);
  if (variance <= 0.0 ) return (2);
  if (( work = AllocBuffer(dpt) ) == NULL ) return (8);

  Gen_M_series(init, M);
  J = 0;
  
#ifdef _DEBUG_ISPP
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  for (i = 0; i < dpt; i++)
    work[i] = rnd_nor(i, mean, variance, M, &J);
  
  ReturnSeries(work, dim, idx);
  FreeBuffer(work);

  return 0;
}



#ifdef __cplusplus
}
#endif
