/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: phase.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/****************************************************
*                                                   *
*    PHASE IBX , IBY , D , U                        *
*          IBX : REAL PART                          *
*          IBY : IMAGINARY PART                     *
*          D   : DEGREE , OTHERWISE : RADIAN        *
*          U   : UNWRAPP OR NOT                     *
*                                                   *
*  CODED BY A.Fujisaki     2,13 , 87                *
*  MODIFIED BY K.TAKEBE    APRIL 19, 1993           *
****************************************************/

#define PAI   M_PI
#define PAI2  (PAI*2)

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_phase(){
  Buffer *data1, *data2, *dat1, *dat2, *max;
  Buffer phps, phng, dif, dph, dph1, dph2;
  int	 icon, iucn, dptr, dpti, dimr, dimi;
  int    indexr[MAX_INDEX], indexi[MAX_INDEX];
  char   *ic, *iu;

  data1 = GetSeries(0, &dimr, indexr);
  data2 = GetSeries(1, &dimi, indexi);
  ic    = GetString(2);
  iu    = GetString(3);

  if ( data1 == NULL || data2 == NULL )
    return ( 4 );
    
  icon = -1;
  if( ic[0] == 'D' )
    icon = 1;
  
  iucn = -1;
  if( iu[0] == 'U' )
    iucn = 1;
  
  dptr = IndexSize( dimr, indexr );
  dpti = IndexSize( dimi, indexi );

  if( dptr != dpti )
    return ( 7 ) ;
  
  max = data1+dptr;

  /***** Calculation of Phase *****/
  for( dat1 = data1, dat2 = data2; dat1 < max; dat1++, dat2++ ) {
    if ( fabs(*dat1) > DBL_EPSILON || fabs(*dat2) > DBL_EPSILON )
      *dat1 = atan2( *dat2, *dat1 );
    else
      *dat1 = 0.0; 
  }

  /***** Unwrap *****/
  if ( iucn == 1 ) {
    phps = 0.0;
    phng = 0.0;
    
    for ( dat1 = data1+1, dat2 = data1; dat1 < max; dat1++, dat2++ ) {

      dif = (*dat1 + phps - phng ) - (*dat2);
      dph =  fabs( dif );
      dph1 = fabs( dif + PAI2 );
      dph2 = fabs( dif - PAI2 );
      
      if ( dph-dph1 > DBL_EPSILON )
	phps += PAI2;
      else if ( dph-dph2 > DBL_EPSILON )
	phng += PAI2;

      *dat1 += ( phps - phng ) ;
    }
  }
  
  /***** Transform from Rad. to Deg. *****/
  if ( icon == 1 )
    for ( dat1 = data1 ; dat1 < max; dat1++ )
      (*dat1) *= ( 360.0 / PAI2 );
  
  /***** Write Data to Common Area *****/
  ReturnSeries( data1, dimr, indexr ) ;
  return 0;
}

#ifdef __cplusplus
}
#endif
