/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: power.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*****************************************************
*	x = power(real, imag);                       *
*****************************************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_power()
{
  register int    i, n;
  int             dim1, dim2, index1[MAX_INDEX], index2[MAX_INDEX];
  Buffer         *real, *imag;
  
  real = GetSeries(0, &dim1, index1);
  imag = GetSeries(1, &dim2, index2);
  
  if (real == NULL || imag == NULL) return (4);
  if (dim1 != dim2) return (16);
  if (!EqualIndex(index1,index2,dim1)) return (18);
      
  /***** Calculation of ( re**2 + im**2 ) *****/
  n = IndexSize(dim1,index1);
  for (i = 0; i < n; i++)
    real[i] = real[i] * real[i] + imag[i] * imag[i];

  ReturnSeries(real, dim1, index1);
  return 0;
}
#ifdef __cplusplus
}
#endif
