/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: trans.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : trans          *
*    ( Ver 1.0 : 1993/03/09 )  *
********************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

void trans(Buffer *x,Buffer *y,int dp1,int dp2 ){
  int k, i, dpt;

  for ( k = 0; k < dp1; k++ ) {
    dpt = dp2*k;
    for ( i = 0; i < dp2; i++ )
      y[ dp1*i+k ] = x[ i+dpt ];
  }
}

DLLEXPORT int mod_ispp_trans(){
  Buffer *x, *y, *xx, *yy, *max;
  int    idx[MAX_INDEX],idx2[MAX_INDEX];
  int    dim, m, n, i, l;

  x = GetSeries( 0, &dim, idx);
  if ( x == NULL )
    return (4);

  if ( dim == 1 ) {
    dim = 2;
    idx[1] = idx[0];
    idx[0] = 1;
  }

  l = IndexSize( dim, idx );
  if (( y = AllocBuffer( l ) ) == NULL )
    return (8);

  m = idx2[dim-1] = idx[dim-2];
  n = idx2[dim-2] = idx[dim-1];

  for ( i = 0; i < dim-2; i++ )
    idx2[i] = idx[i];

  max = x+l;
  i   = m*n;

  for ( xx = x, yy = y; xx < max; xx+=i, yy+=i )
    trans( xx, yy, m, n );


  ReturnSeries( y, dim, idx2 );
  FreeBuffer( y );
  FreeBuffer( x );
  return 0;
}

#ifdef __cplusplus
}
#endif
