/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: urand.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "rand_sub.h"
/******************************************
  
      "URAND  DPT , INIT , LOWER , UPPER "
  
	DPT   : output data point
	INIT  : initial value
        LOWER : lower value
	UPPER : upper value
  
        Date 28th Oct 1988 by M.Akima
	Modified by S.Hitomi Jul. 24, 1992
******************************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ispp_urand(){
  int          dpt;
  int          init;
  double       lower, upper;
  Buffer       *work;
  register int i;
  int          dim = 1, idx[MAX_INDEX];
  
  int          M[521], J;
  
  idx[0] = dpt = (int)GetScalar(0);
  init = (int)GetScalar(1);
  lower = GetScalar(2);
  upper = GetScalar(3);

  if (( work = AllocBuffer(dpt) ) == NULL )
    return (4);

  Gen_M_series(init, M);
  J = 0;
  
#ifdef DEBUG
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  for (i = 0; i < dpt; i++)
    work[i] = rnd_uni(lower, upper, M, &J);
  
  ReturnSeries(work, dim, idx);
  return 0;
}
  
#ifdef __cplusplus
}
#endif
