/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncal.cpp,v 1.4 2005/10/30 11:04:20 orrisroot Exp $ */

/*****************************************************************************
  
                   NCS CALCULATION COMMAND
  
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>

#ifdef WIN32
#include <process.h>
#include <direct.h>
#include <io.h>
#else
#include <unistd.h>
#endif

#include "SL_header.h"

using namespace std;

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "ncs.h"

#define printf          syscom->console->tty_printf

#define CONSOLE(x) syscom->console->x
#ifndef _MAX_PATH
# ifdef  MAXPATHLEN
#  define _MAX_PATH  MAXPATHLEN
# else
#  define _MAX_PATH  1024
# endif
#endif

static SL_Object *object_lookup(const char *var){
  symbol_t *sym;
  sym = symbol_table_lookup(syscom->cur_symtab,var);
  if(sym == NULL) return NULL;
  return sym->object;
}

static void assign_result_to_buffer(){
  SL_Object *obj;
  Series_Buffer *buf;
  Index idx;
  OutFile oscf;
  int i, dsize_org;
  char *bn;
  char fname[NCS_FNAME_WD];
  Header head;
  double *data;
  dsize_org = sl2_get_data_size();
  for(i=0;OutGetInfoSCF(&oscf,i) == NCS_TRUE;i++){
    if(oscf.type != SCF_OUT_BUFF_OUT  &&
       oscf.type != SCF_OUT_BUFF_EXIN &&
       oscf.type != SCF_OUT_BUFF_OBS) continue;
    bn = oscf.out.rec3.buf_name;
    if(bn[0]=='\0'){ 
      /* TODO: null scfout buffname */
      printf("ncal error : outscf(%d) bufname is null\n",i);
      continue;
    }
    obj = object_lookup(bn);
    if(obj==NULL){
      printf("ncal error symbol(%s) is null\n",bn);
      break;
    }
    sprintf(fname,"%s/nout_%s.fobj", get_tmpdir(), bn);
    data = (double*)_ReadFile(fname, &head);
    if(data == NULL){
      printf("ncal error : fileobject can't read\n");
      break;
    }
    idx.SetIndexInfo(head.dim,head.index);
    obj->Init(SL_OBJ::SERIES_O,idx);
    //obj->Destroy();
    //obj->Init(SL_OBJ::SERIES_O);

    buf=(Series_Buffer*)obj->GetBufferPointer();
    //buf->SetIndexInfo(head.dim,head.index);
    //buf->InitBuffer();

    memcpy(buf->GetDataPointer(),
           data,buf->IndexSize()*sizeof(double));
    FreeData(data);
  }
  ChangeDataSize(dsize_org);
}

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ncs_ncal()
{
  char  scf_name[NCS_FNAME_WD];
  int   pid, code;
  char  bin[_MAX_PATH], libpath[_MAX_PATH], tmp[_MAX_PATH];
  const char *ncs_tmpdir;

  ncs_tmpdir = get_tmpdir();

  if( ModelNameSCFN( scf_name ) == NULL ){
    return (6);
  }
  
#ifdef WIN32
  GetModuleDirectory(tmp, _MAX_PATH);
  snprintf(bin, _MAX_PATH, "\"%s/ncs/ncssim.exe\"", tmp);
  snprintf(libpath, _MAX_PATH, "%s\\..;%s\ncs", tmp, tmp);
#else
  snprintf(bin, _MAX_PATH, "%s/%s", ncs_tmpdir, scf_name);
  snprintf(libpath, _MAX_PATH, "%s:%s", SL4_LIB_DIR, NCS_LIB_DIR);
#endif

  store_syscom_file();
  pid = create_child_process(bin, CONSOLE(ifd), CONSOLE(ofd), CONSOLE(efd),
                             libpath);
  code = 0;
  if(pid == -1){
    code = 436; /* could not create process */
  }else{
    int status;
    status = wait_child_process(pid, &code);
    if(status == -1){
      code = 450; /* process not found */
    }else if(status == 0){  /* normal exit */
      /* nothing */
    }else if(status == 1){
      code = 451; /* signal caught */
    }else if(status == 2){
      code = 452; /* process is stoping */
    }else if(status == 3){
      code = 453; /* core dumped */
    }else{ 
      code = 454; /* unknown error */
    }
  }
  unlink_syscom_file();

  assign_result_to_buffer();
  return code; /*succeed*/
}

#ifdef __cplusplus
}
#endif
