/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nchgbuff.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************
  
         	NCS SIMULATION CONDITION SETTING COMMAND
                 SETTING OF NUMBER OF BUFFER TO OUTPUTS 

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#ifdef HAVE_SYSTYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
# ifndef O_BINARY
#  define O_BINARY 0
# endif
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

#ifdef __cplusplus
extern "C" {
#endif

#define  OFFSET_HEAD	0L
#define  OUTPUT_FILE	"NCSOUT.DAT"
#define  RECSIZE		(sizeof(struct scf_out))
#define  RECORD1		(0)
#define  RECORD2		(RECSIZE)
#define  RECORD3		(RECSIZE*2)
#define  RECORD4		(RECSIZE*3)
#define  PRMNUM			5

#ifndef L_SET
#define L_SET  0
#define L_INCR 1
#define L_XTND 2
#endif

#define  ISPP_BUFF_MIN  4         /* MINIMUM NUMBER OF ISPP BUFFER */
#define  ISPP_BUFF_MAX  255        /* MAXIMUM NUMBER OF ISPP BUFFER */

static int
Check_buff_num( int fd_out )
{
  int             ret, DataNo;
  long            offset;
  struct scf_out  sc;
  
  offset = RECORD1;
  lseek(fd_out, offset, L_SET);
  DataNo = 0;
  while ((ret = read(fd_out, (char *) &sc, RECSIZE)) != -1
         && sc.type != SCF_EOF
         && ret >= RECSIZE ) {
    DataNo++;
    /*		fprintf( stderr, "sc.rec_type = %c\n", sc.rec_type );*/
    if( sc.type == SCF_OUT_BUFF_SIZE ){
      return (DataNo);
    }
  }
  return (0);
}

/**************************************************************************
	fd_out  : file pointer of *.OUT 
	argv[]  : argument of nout* 
	data_num: ( != 0) Nth data. ( == 0 ) additional data. 
***************************************************************************/
static void
Set_out_info( int fd_out, int data_num, int number )
{
  long            offset;
  struct scf_out  sc;
  
  offset = RECORD1 + (data_num - 1) * RECSIZE;
  lseek(fd_out, offset, L_SET);
  sc.out.rec4.max_number = number;
  sc.type = SCF_OUT_BUFF_SIZE;
  write(fd_out, (char *) &sc, sizeof(struct scf_out));
}

/*****************************************************************************

        NCHGBUFF main function


*****************************************************************************/

DLLEXPORT int mod_ncs_nchgbuff(){
  int     fd_out, DataNo;
  char    scfn[NCS_FNAME_WD], fname_wd[NCS_FNAME_WD];
  int 	number;
  
  if( ModelNameSCFN( scfn ) == NULL ){
    return(6);
  }
  sprintf(fname_wd, "%s/%s.%s", get_tmpdir(), scfn, SCF_OUT_EXTN);
  
  number = (int)GetScalar(0);
  
  if( number <= SCF_OUT_BUFF_MAX ){
    printf( "Wanning: Value(%d) is less than default(%d).\n",
            number, SCF_OUT_BUFF_MAX );
    return(0);
  }
  
  if ((fd_out = open(fname_wd, O_RDWR | O_BINARY)) == -1){
    return(1);
  }
  
  if( ( DataNo = Check_buff_num( fd_out )) == 0 ){
    fprintf( stderr, "Error:Check_buff_num()\n" );
    return( 290 );
  }
    
  Set_out_info( fd_out, DataNo, number );
  
  close( fd_out );
  return( 0 );
}

#ifdef __cplusplus
}
#endif
