/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nout.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************
  
         	NCS SIMULATION CONDITION SETTING COMMAND
                          SETTING OF OUTPUTS 
  
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

using namespace std;

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ncs_nout(){
  int	 buf_id, comp_no, type;
  char	*mdl_name, *obs_name;
  int    buf_dim;
  char	*tmp;
  const char  *buf_name;
  symbol_t *sym;
  OutFile out_info;
  ObsFile obs_info;
  
  buf_id = 0;
  sym = syscom->get_symbol(0);
  if(sym == 0) return 440;
  buf_name = sym->name;
  
  tmp = GetArgType(1);

  if( strcmp( "string", tmp ) == 0 ){
    buf_dim = 0;
    mdl_name = GetString(1);
    comp_no = (int)GetScalar(2);
    type = (int)GetScalar(3);
    obs_name = GetString(4);
    
    if( type < 3 && GetArgNum() > 4){
      return 292;
    }

    if (GetArgNum() == 4 && type == 3) {
      printf("Observable : ");
      scanf("%s", obs_name);
    }
  }else{
    buf_dim = (int)GetScalar(1);
    mdl_name = GetString(2);
    comp_no = (int)GetScalar(3);
    type = (int)GetScalar(4);
    obs_name = GetString(5);

    if( type < 3 && GetArgNum() > 5){
      return 292;
    }

    if (GetArgNum() == 5 && type == 3) {
      printf("Observable : ");
      scanf("%s", obs_name);
    }
  }

  /* 
  if( buf_id == 0 ){
    fprintf( stderr, "\'%s\' not buffer\n", buf_name );
    return(216);
  }
  */
  
  if( type > 3 ){
    return(212);
  }

  /* convert buffer to file object */
  /* if already exist same buffer name in nout lists then override one */
  {
    int      dim,index[MAX_INDEX];
    int      dsize_org;
    double  *buffer;
    char     fname[NCS_FNAME_WD];
    buffer = GetSeries(0, &dim, index);
    if(buffer == NULL) return (211);
    dsize_org = sl2_get_data_size();
    ChangeDataSize(8);
    sprintf( fname, "%s/nout_%s.fobj", get_tmpdir(), buf_name);
    _WriteFile4(fname, dim, index, (char*)buffer);
    ChangeDataSize(dsize_org); /* restore data size */
  }

  /* memory clear */
  memset(&obs_info, 0, sizeof(ObsFile));
  memset(&out_info, 0, sizeof(OutFile));
  
  if( type == 3 ){
    if( ObsSetInfoSCF( &obs_info, mdl_name, comp_no, obs_name )
        == NCS_FALSE ){
      return(56);
    }
    if( ObsSearchInfoSCF( &obs_info ) < 0 ){
      fprintf( stderr, "Module: %s, Variable: %s\n", mdl_name, obs_name );
      return(58);
    }
  }
  /*scfout.cpp*/
  if( OutSetInfoSCF( &out_info, buf_id, buf_name, buf_dim, 
                     mdl_name, comp_no, type, obs_name ) == NCS_FALSE ){
    return(51);
  }
  /*scfout.cpp*/
  if( OutWriteInfoSCF( &out_info ) == NCS_FALSE ){
    return(52);
  }
  
  return( 0 );
}
  
#ifdef __cplusplus
}
#endif
