/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: npara.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************

             	NCS SIMULATION CONDITION SETTING COMMAND 
                          SETTING OF PARAMETERS

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_ncs_npara(){
  char	 *mdl_name, *prm_name;
  double  prm_real;
  char    flag;
  PrmFile prm;

  mdl_name = GetString(0);
  prm_name = GetString(1);
  prm_real = GetScalar(2);

  flag = SCF_PRM_TYPE_NORMAL;
  PrmSetInfoSCF( &prm, &flag, mdl_name, prm_name, prm_real );
  if( PrmWriteInfoSCF( &prm ) == NCS_FALSE ){
    fprintf( stderr, "Can't Find the Parameter[%s:%s]\n", 
             mdl_name, prm_name );
    return(61);
  }
  
  return( 0 );
}

#ifdef __cplusplus
}
#endif
