/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nsclst.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************

             	NCS SIMULATION CONDITION DISPLAY COMMAND
                    CONTENTS OF SIMULATION CONDITIONS

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "nlist.h"

#ifdef WIN32
#define unlink(x) _unlink(x)
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*****************************************************************************

             NCS SIMULATION CONDITION DSPLAY COMMAND 
                      MAIN FUNCTION

on UNIX                                      05/07/1990 CODED BY S.Hitomi
*****************************************************************************/

DLLEXPORT int mod_ncs_nsclst(){
  const char *tmpdir;
  char    *type;
  char    tmpfile[NCS_FNAME_WD];
  int     row = 0;
  char    scfn[NCS_FNAME_WD];
  int     narg;

  type = GetString(0);
  
  narg = GetArgNum();

  if( narg != 1 ){
    *type = 99;
  }

  tmpdir = get_tmpdir();

  /* make file name */
  if(ModelNameSCFN( scfn ) == NULL){
    return (6);
  }

  /* open temprary file */
#ifdef HAVE_SNPRINTF
  snprintf(tmpfile, NCS_FNAME_WD, "%s/%s", tmpdir, TMPNLIST);
#else
  sprintf(tmpfile, "%s/%s", tmpdir, TMPNLIST);
#endif
  /* remove current temporary file */
  unlink(tmpfile);


  switch( *type ){
  case '1':
  case 's':
  case 'S':
    row = XfpListupAllSCF( tmpfile );
    break;
    
  case '2':
  case 'o':
  case 'O':
    row = OutListupSCF( tmpfile );
    break;
    
  case '3':
  case 't':
  case 'T':
    row = MatTimeListupSCF( tmpfile );
    break;
    
  case '4':
  case 'd':
  case 'D':
    row = DlyListupSCF( tmpfile );
    break;
    
  case '5':
  case 'i':
  case 'I':
    row = MatIntegListupSCF( tmpfile );
    break;
    
  case '6':
  case 'b':
  case 'B':
    row = ObsListupSCF( tmpfile );
    break;
    
  default:
    fprintf( stderr, "Usage : NSCLST " );
    fprintf( stderr, " Stimulus/Output/Timer/Delay/Integration\n" );
    fprintf( stderr, "               "  );
    fprintf( stderr, " ~        ~      ~     ~     ~\n" );
    break;
  }
  if( row > 0 ){
    return screen_out( tmpfile, row );
  }
  
  return( 0 );
  
}
  
#ifdef __cplusplus
}
#endif
