/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nstim-numget.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <ctype.h>

#include "nstim.h"

#define	getint()  while(isdigit((int)*streamptr)) streamptr++/* ; */

static char *exponent(char *stream){
  char   c, *streamptr = stream;

  /* e, E */
  if ((c = *streamptr) != 'e' && c != 'E')
    return stream;		/* not accept */

  streamptr++;
  /* +, - */
  if ((c = *streamptr) != '+' && c != '-' && !isdigit((int)c))
    return stream;		/* not accept */

  if (!isdigit((int)c))
    streamptr++;

  /* Exponent */
  if (isdigit((int)*streamptr)) {
    getint();
    return streamptr;		/* accept */
  } else
    return stream;		/* not accept */
}

char  *nstim_getnum(char *stream){
  char  *streamptr = stream;

  /* Float */
  /* integer */
  getint();

  if (*streamptr == '.') {	/* decimal point */
    streamptr++;
    getint();			/* decimal */
  }
  /* if '.' only */
  if (stream[0] == '.' && stream + 1 == streamptr)
    return stream;		/* not accept */

  streamptr = exponent(streamptr);
  return streamptr;
}

#if 0

main()
{
  print("ABCDEFGIHJKLMN");
  print(".ABCDEFGIHJKLMN");

  print(".");
  print("..");
  print(".0");
  print(".0e0");
  print(".e");
  print(".e0");

  print("+123");
  print("-123");
  print("0000012345");

  print("123");
  print("123e");
  print("123e5");
  print("123e+5");
  print("123e-5");

  print("0.");
  print("1234.eee");
  print(".12345");
  print("123.45");
  print("123.45exp");
  print("123.E5");
  print("123.45E5");
  print("123.45E+5");
  print("123.45E-5");

  print(".123.122");
  print(".123e");
  print(".123eabcdefg");
  print(".123e-abcdefg");
  print(".123e+4w");
  print(".123e+4.");
}


print(str)
     char  *str;
{

  int    len;
  char  *next = str;
  char   num[40];

  printf("(%-15s)\t", str);

  next = getnum(str);
  len = next - str;

  printf("len = %2d\t", len);
  num[len] = NULL;
  strncpy(num, str, len);

  printf("number[%-10s]\t", num);
  printf("next[%s]\n", next);
}
#endif
