/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nstim-pmatch.cpp,v 1.2 2004/09/28 04:18:31 orrisroot Exp $ */
/*****************************************************************************
  
                     Functions to Pattern Matching

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "nstim.h"

#ifdef __cplusplus
extern "C" {
#endif

/*  original source lex file 'number_or_not.l' */
static void number_or_not_l(char *s, int *char_num, char *outbuf){
  int len;
  len = (int)strlen(s);
  for(*char_num=0;*char_num<len && *char_num<=64;*char_num++){
    if(isdigit(s[*char_num])==0)
      outbuf[*char_num]=1;
    else
      outbuf[*char_num]=0;
  }
}

int nstim_digit_or_not( char *s ){
  char outbuf[64];
  int  char_num;
  if( s==NULL) return (0);
  if( strlen(s) == 0 ){
    return( 0 );
  }
  char_num = 0;
  /* yy_scan_string(s); */
  /* yylex(s); */
  number_or_not_l(s, &char_num, outbuf);
  outbuf[char_num] = '\0';
  if( (char_num == 1 ) && ( outbuf[0] == '1' )){
    return( 1 );
  }else{
    return( 0 );
  }
}

#ifdef __cplusplus
}
#endif
