/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nstim.cpp,v 1.3 2005/02/23 04:40:22 orrisroot Exp $ */
/*****************************************************************************

                 NCS SIMULATION CONDITION SETTING COMMAND 
                         SETTING OF EXTERNAL INPUTS

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"
#include "nstim.h"

#define INPUT(a,b,c,d) nstim_input((a),(b),(c),(d))

#ifdef __cplusplus
extern "C" {
#endif

int ncs_get_p( char type, double val[], char *fname, char *buff_name ){
  double  d;
  switch( type ){
  case 'P':
    printf(" Start time    : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[0] = d;
    printf(" Initial Value : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[1] = d;
    printf(" Height        : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[2] = d;
    printf(" Width         : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[3] = d;
    printf(" Period        : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[4] = d;
    break;
  case 'R':
    printf(" Start time    : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[0] = d;
    printf(" Initial Value : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[1] = d;
    printf(" Gradient      : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[2] = d;
    break;
  case 'F':
    fname[0] = NCS_EOS;
    while( strlen( fname ) == 0 ){
      printf(" File name     : ");
      INPUT( NCS_FNAME_WD, fname, NULL, NULL ); 
    }
    printf("Buffer number  : ");
    INPUT( NCS_FNAME_WD, NULL, NULL, &d ); 
    val[1] = d;
    break;
  case 'B':
    printf("can't set series object");
    return( NCS_ERROR );
    break;
  default:
    return( NCS_ERROR );
  }
  return NCS_SUCCESS;
}
  
/***************************************************************
 argc : 3 + 3 or 5
 argv[0]: nstim
 argv[1]: Module name
 argv[2]: Compornent No.
 argv[3]: Function  ( R: Ramp, P: Pulse, F: File, B: Buffer )
 argv[4]: start time of input
 argv[5]: initial value of input
 argv[6]: [R]gradient, [P]height
 argv[7]: [R]null,     [P]width
 argv[8]:              [P]period
 argv[9]:              [P]null
 ***************************************************************/

DLLEXPORT int mod_ncs_nstim(){
  char       *mdl_name, infile[NCS_FNAME_WD], *type;
  char        tmp[NCS_FNAME_WD];
  int         i, comp_no;
  double      val[5];
  char       *buf_name=NULL;
  char       *buf_time=NULL;
  XinFile     sc_xin;
  XfpFile     sc_xfp;

  const char *tmpdir;

  mdl_name = GetString(0);       /* model name */
  comp_no  = (int) GetScalar(1); /* number of component */
  type     = GetString(2);       /* type of input stimulus 'P' 'R' 'B' 'F' */
  for( i = 0; i < 5; i++ ){
    val[i] = GetScalar(3 + i);
  }

 tmpdir = get_tmpdir();

  if( strcmp(type,"B") == 0 ){
    /* convert buffer to fileobject when input stimlus type is "B" */
    Buffer *x;
    int     dim, index[MAX_INDEX], dsize_org;
    buf_name = GetString( 3 );
    x = GetSeries( 3, &dim, index );
    if(x == NULL)
      return (216); /* argument 3 is not buffer */
    /* create data file */
    /* TODO size check */
    snprintf(infile, NCS_FNAME_WD, "nstim_%s-%d.fobj", mdl_name, comp_no);
    snprintf(tmp, NCS_FNAME_WD, "%s/%s", tmpdir, infile);
    dsize_org = sl2_get_data_size();
    ChangeDataSize(8);
    _WriteFile4(tmp, dim, index, (char *)x);
    ChangeDataSize(dsize_org);
    /* TODO : check time info */
    buf_time = GetString(4); /* get argument string no. 4 */
    /* if p2 is number then time info may be set to p3 */
    if( nstim_digit_or_not(buf_time) == 1){
      buf_time = GetString(5); /* get argument stirng no. 5 */
      /* if p3 is number then time info not seted */
      if( nstim_digit_or_not(buf_time) == 1){
        /* p3 is not time info */
        buf_time = NULL;
      }
    }else{
      val[2] = val[1];
      val[1] = 0;
    }
    /* val[1] : array index */
    /* val[2] : time info   */
  }
#ifdef DSPTEC_EXTENSION
  if( strcmp(type,"A") == 0 ) {
    /* reserved for A/D board extension by DSP Technology Co. Ltd */
    /* implementation not yet */
  }
#endif

  if( GetArgNum() == 3 ){
    ncs_get_p( *type, val, infile, buf_name );
  }


  memset(&sc_xin, 0, sizeof(XinFile));
  memset(&sc_xfp, 0, sizeof(XfpFile));
  XinSetInfoSCF( &sc_xin, mdl_name, comp_no );
  XfpSetInfoSCF( &sc_xfp, type, val, infile, buf_name, buf_time );
  XfpSetStimSCF( &sc_xin, &sc_xfp );
  
  return( 0 );

  }

#ifdef __cplusplus
}
#endif
