/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: nrtclk.cpp,v 1.3 2004/08/24 08:18:47 yoshihiko Exp $ */
/*****************************************************************************

                  NCS SIMULATION CONDITION SETTING COMMAND 

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libncsc.h"

#define printf          syscom->console->tty_printf

#define CONSOLE(x) syscom->console->x
#ifndef _MAX_PATH
# ifdef  MAXPATHLEN
#  define _MAX_PATH  MAXPATHLEN
# else
#  define _MAX_PATH  1024
# endif
#endif

static SL_Object *object_lookup(const char *var){
  symbol_t *sym;
  sym = symbol_table_lookup(syscom->cur_symtab,var);
  if(sym == NULL) return NULL;
  return sym->object;
}

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DSPTEC_EXTENSION

static bool modify_extncs_code(char *mdlname, char *obsname);
static bool modify_extncs_source(char* mdlname, int point, double *data);

DLLEXPORT int mod_ncs_nrtclk(){
  char       *rtflag;
  int         rtclk,rtdisp;
  FILE       *fp;
  const char *path;
  char 	      mname[SCF_SCFN_PATH_SIZE];
  char 	      fname[SCF_SCFN_PATH_SIZE];
  MatFile     sc;
  char	     *obsname;
  char		 *mdlname;
  
  SetWorkDirSCF( get_tmpdir() );
  
  rtclk = NCS_FALSE;
  if( (rtflag = GetString(0)) != NULL) {
    if( strcmp(rtflag,"ON") == 0) {
      /* if integral method is auto scarf then disable realtime calculation */
      MatGetInfoSCF( &sc, 0 );
      if(sc.integral.method == 'F')
        return (435);
      rtclk = NCS_TRUE;
    }
    if( strcmp(rtflag,"3") == 0) {
      /* if integral method is auto scarf then disable realtime calculation */
      MatGetInfoSCF( &sc, 0 );
      if(sc.integral.method == 'F')
        return (435);
      rtclk = 3;
    }
    if( strcmp(rtflag,"2") == 0) {
      rtclk = 2;
    }
	if( strcmp(rtflag,"T") == 0) {
		/* Modified source file */
		mdlname = GetString(1);
		obsname = GetString(2);
		if(modify_extncs_code(mdlname, obsname) == NCS_FALSE) {
		  return( 437 );
		}
		return( 0 );
	}
  }
  rtdisp = NCS_FALSE;
  if( (rtflag = GetString(1)) != NULL) {
    if(strcmp(rtflag,"ON") == NULL)
      rtdisp = NCS_TRUE;
  }
  
  /* DA output variable */
  obsname = GetString(2);

  if( (path=GetWorkDirSCF()) != NULL ){
    sprintf( fname, "%s/%s.%s", 
             path, ModelNameSCFN( mname ), "rtc" );
    fp = fopen(fname,"w");
    if(fp == NULL)
      return (434);
    if(obsname == NULL)
      fprintf(fp,"%d %d\n",rtclk,rtdisp);
    else
      fprintf(fp,"%d %d %s\n",rtclk,rtdisp,obsname);
    
    fclose(fp);
    return( 0 );
  }
  return (434);
}

static bool modify_extncs_code(char *mdlname, char *obsname)
{
  SL_Object *obj;
  Base_Buffer* buffer;
  int i,dim,idx[10];
  double* dptr;

  obj = object_lookup(obsname);
  if(obj==NULL){
    printf("error symbol(%s) is null\n",obsname);
	return NCS_FALSE;
  }
  buffer = obj->GetBufferPointer();
  dim = buffer->GetDim();
  if(dim != 1) {
    printf("error dimension(%d) is large\n",dim);
    return NCS_FALSE;
  }
  for(i = 0; i < dim; i++)
    idx[i] = buffer->GetIndex(i);
  dptr = (double*)buffer->GetDataPointer();
  //Debug
  //for(i = 0; i < idx[0]; i++)
  //	  printf("%f\n", dptr[i]);

  //Modify
  if(modify_extncs_source(mdlname, idx[0], dptr) == NCS_FALSE) {
      printf("error size(10000) is over\n");
	  return NCS_FALSE;
  }
  return NCS_TRUE;
}

static bool modify_extncs_source(char* mdlname, int point, double *data)
{
  const char *path;
  char 	      fname[SCF_SCFN_PATH_SIZE];
  char 	      mname[SCF_SCFN_PATH_SIZE];
  char linebuf[_MAX_PATH];
  char target[_MAX_PATH];
  FILE* fp;
  char	*list[10000];
  int i,nDelLine,addr=0,nTarget = 0;

  for(i = 0; i < 10000; i++)
    list[i] = 0;
  if( (path=GetWorkDirSCF()) != NULL ){
    sprintf( fname, "%s/%s.%s", 
             path, ModelNameSCFN( mname ), "cpp" );
	sprintf(target,"double %s(double NcsTime", mdlname);
    fp = fopen(fname,"r");
    while(!feof(fp)) {
	  if(fgets(linebuf, _MAX_PATH, fp) == NULL)
	    break;
	  linebuf[strlen(linebuf)-1] = '\0';
	  if(addr == 9999) goto fullerr;
	  list[addr] = (char *)malloc(strlen(linebuf)+1);
	  strcpy(list[addr++], linebuf);
	  if(strstr(linebuf, target)) {
		  if(nTarget == 0) {
			// set "{"
 			fgets(linebuf, _MAX_PATH, fp);
			linebuf[strlen(linebuf)-1] = '\0';
			if(addr == 9999) goto fullerr;
			list[addr] = (char *)malloc(strlen(linebuf)+1);
			strcpy(list[addr++], linebuf);
			// set "static int index=0;"
			strcpy(linebuf,"\tstatic int index=0;");
			if(addr == 9999) goto fullerr;
			list[addr] = (char *)malloc(strlen(linebuf)+1);
			strcpy(list[addr++], linebuf);
			// set table
			for(i = 0; i < point; i++) {
				if(i == 0) {
					if(addr == 9999) goto fullerr;
					sprintf(linebuf,"\tstatic double pTbl[]={ %f,",*data++);
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
				}
				else if(i == point-1) {
					if(addr == 9999) goto fullerr;
					sprintf(linebuf,"\t%f };",*data++);
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
				}
				else {
					if(addr == 9999) goto fullerr;
					sprintf(linebuf,"\t%f,",*data++);
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
				}
			}
			// set next
			strcpy(target, "out = 0.000000e+000");
			nTarget++;
		  }
		  else if(nTarget == 1) {
			  nDelLine = addr-1;
			  strcpy(linebuf,"\tout = pTbl[index++];");
					if(addr == 9999) goto fullerr;
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
			  sprintf(linebuf,"\tif(index == %d)", point);
					if(addr == 9999) goto fullerr;
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
			  strcpy(linebuf,"\t\tindex=0;");
					if(addr == 9999) goto fullerr;
					list[addr] = (char *)malloc(strlen(linebuf)+1);
					strcpy(list[addr++], linebuf);
			nTarget++;
		  }
		}
	}
fullerr:
	fclose(fp);

	//write
	if(addr == 9999) {
	  for(i = 0; i < 10000; i++) {
		if(list[i])
			free(list[i]);
	  }
	  return NCS_FALSE;
	}
	else {
      fp = fopen(fname,"w");
	  for(i = 0; i < 10000; i++) {
		if(list[i]) {
			if(i != nDelLine)
				fprintf(fp,"%s\n",list[i]);
			free(list[i]);
		}
	  }
	  fclose(fp);
	  return NCS_TRUE;
    }
  }
  return NCS_FALSE;
}

#endif
  
#ifdef __cplusplus
}
#endif
