#
# hhmodel.sl
#
nassign("hhmodel");
npp();
nlink("-O2");

series V,Iin,INa0;
nout(Iin,"hhmodel",0,2);
nout(V,"hhmodel",0,1);
nout(INa0,"hhmodel",0,3,"INa");

ntime(10,0.001,0.01,1);
nstim("hhmodel",0,"P",1,0,100,3,999);

ninteg("R");
ncal();

wopen(1,"A4",0,0);
origin(40,40);

time=(0~1000)/100;
# V plot
color("red","black");
scale("N","F","N","F",0,10,-20,120);
graph(V,time,0,0,0,1,3.5);
title(1,"time [ms]","membrane potential [mV]");
axis(1,1,"XY","XY",6,0,3,0,0,0);
# INa0 plot
color("blue","black");
scale("N","F","N","F",0,10,-1000,100);
graph(INa0,time,0,0,0,1,3.5);
title(1,"time [ms]","INa");
axis(1,3,"XY","XY",6,0,3,0,0,0);
frame();

